/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.valid;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import com.microsoft.tfs.util.valid.IValidationMessage;
import com.microsoft.tfs.util.valid.IValidity;
import com.microsoft.tfs.util.valid.ValidationUtils;
import com.microsoft.tfs.util.valid.Validator;
import com.microsoft.tfs.util.valid.Validity;
import com.microsoft.tfs.util.valid.ValidityChangedEvent;
import com.microsoft.tfs.util.valid.ValidityChangedListener;

public abstract class AbstractValidator
implements Validator {
    private final SingleListenerFacade validityChangedListeners = new SingleListenerFacade(ValidityChangedListener.class);
    private final Object subject;
    private IValidity validity;
    private final Object validityLock = new Object();
    private boolean suspend;
    private IValidity suspendedValidity;
    private final Object suspendLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractValidator(Object subject) {
        Check.notNull(subject, "subject");
        this.subject = subject;
        Object object = this.validityLock;
        synchronized (object) {
            this.validity = Validity.VALID;
        }
        object = this.suspendLock;
        synchronized (object) {
            this.suspend = false;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getSubject() {
        return this.subject;
    }

    @Override
    public void addValidityChangedListener(ValidityChangedListener listener) {
        this.validityChangedListeners.addListener(listener);
    }

    @Override
    public void removeValidityChangedListener(ValidityChangedListener listener) {
        this.validityChangedListeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValidity getValidity() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspend) {
                return this.suspendedValidity;
            }
        }
        object = this.validityLock;
        synchronized (object) {
            return this.validity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setValidity(IValidity newValidity) {
        Check.notNull(newValidity, "newValidity");
        AbstractValidator abstractValidator = this;
        synchronized (abstractValidator) {
            if (ValidationUtils.validitysEqual(newValidity, this.validity)) {
                return false;
            }
            this.validity = newValidity;
        }
        this.broadcastValidity();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastValidity() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspend) {
                return;
            }
        }
        this.internalBroadcastValidity();
    }

    public void suspendValidation() {
        this.suspendValidation(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendValidation(boolean reset) {
        boolean needBroadcast = false;
        IValidity realValidity = this.getValidity();
        Object object = this.suspendLock;
        synchronized (object) {
            if (!this.suspend) {
                this.suspend = true;
                if (reset) {
                    this.suspendedValidity = Validity.VALID;
                    needBroadcast = !ValidationUtils.validitysEqual(this.suspendedValidity, realValidity);
                } else {
                    this.suspendedValidity = realValidity;
                }
            } else if (reset) {
                Validity newSuspendedValidity = Validity.VALID;
                needBroadcast = !ValidationUtils.validitysEqual(newSuspendedValidity, this.suspendedValidity);
                this.suspendedValidity = newSuspendedValidity;
            }
        }
        if (needBroadcast) {
            this.internalBroadcastValidity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeValidation() {
        IValidity currentValidity;
        boolean needToBroadcast = false;
        Object object = this.validityLock;
        synchronized (object) {
            currentValidity = this.validity;
        }
        object = this.suspendLock;
        synchronized (object) {
            if (!this.suspend) {
                return;
            }
            this.suspend = false;
            needToBroadcast = !ValidationUtils.validitysEqual(currentValidity, this.suspendedValidity);
        }
        if (needToBroadcast) {
            this.internalBroadcastValidity();
        }
    }

    protected boolean setValid(boolean valid) {
        return this.setValidity(valid ? Validity.VALID : Validity.INVALID);
    }

    protected boolean setValid() {
        return this.setValid(true);
    }

    protected boolean setInvalid() {
        return this.setValid(false);
    }

    protected boolean setInvalid(String errorMessage) {
        return this.setValidity(Validity.invalid(errorMessage));
    }

    protected boolean setValidationMessage(IValidationMessage message) {
        return this.setValidity(new Validity(message));
    }

    protected boolean setValidationMessages(IValidationMessage[] messages) {
        return this.setValidity(new Validity(messages));
    }

    private void internalBroadcastValidity() {
        ValidityChangedEvent event = new ValidityChangedEvent(this);
        ValidityChangedListener listener = (ValidityChangedListener)this.validityChangedListeners.getListener();
        listener.validityChanged(event);
    }
}

