/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.valid;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.valid.AbstractValidator;
import com.microsoft.tfs.util.valid.IValidity;
import com.microsoft.tfs.util.valid.Validatable;
import com.microsoft.tfs.util.valid.ValidationUtils;
import com.microsoft.tfs.util.valid.Validator;
import com.microsoft.tfs.util.valid.Validity;
import com.microsoft.tfs.util.valid.ValidityChangedEvent;
import com.microsoft.tfs.util.valid.ValidityChangedListener;
import java.util.ArrayList;
import java.util.List;

public class MultiValidator
extends AbstractValidator {
    private final ValidityChangedListener subValidatorListener = new SubValidatorListener();
    private final List subValidators = new ArrayList();

    public MultiValidator(Object subject) {
        super(subject);
    }

    public boolean addValidatable(Validatable v) {
        Check.notNull(v, "v");
        return this.addValidator(v.getValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addValidator(Validator v) {
        List list = this.subValidators;
        synchronized (list) {
            if (this.subValidators.contains(v)) {
                return false;
            }
            this.subValidators.add(v);
        }
        v.addValidityChangedListener(this.subValidatorListener);
        this.recomputeValidity();
        return true;
    }

    public boolean removeValidatable(Validatable v) {
        Check.notNull(v, "v");
        return this.removeValidator(v.getValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValidator(Validator v) {
        List list = this.subValidators;
        synchronized (list) {
            if (!this.subValidators.contains(v)) {
                return false;
            }
            this.subValidators.remove(v);
        }
        v.removeValidityChangedListener(this.subValidatorListener);
        this.recomputeValidity();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeValidity() {
        Validator[] currentSubValidators;
        List list = this.subValidators;
        synchronized (list) {
            currentSubValidators = this.subValidators.toArray(new Validator[this.subValidators.size()]);
        }
        IValidity[] subValiditys = new IValidity[currentSubValidators.length];
        for (int i = 0; i < currentSubValidators.length; ++i) {
            subValiditys[i] = currentSubValidators[i].getValidity();
        }
        IValidity validity = subValiditys.length == 0 ? Validity.VALID : ValidationUtils.combineValiditys(subValiditys);
        this.setValidity(validity);
    }

    private class SubValidatorListener
    implements ValidityChangedListener {
        private SubValidatorListener() {
        }

        @Override
        public void validityChanged(ValidityChangedEvent event) {
            MultiValidator.this.recomputeValidity();
        }
    }
}

