/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.xml;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.JAXPUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

public class TransformerCache {
    private TransformerFactory factory;
    private final Object factoryLock = new Object();
    private final List cache = new ArrayList();
    private final Method transformerResetMethod;

    public TransformerCache() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerCache(TransformerFactory factory) {
        Object object = this.factoryLock;
        synchronized (object) {
            this.factory = factory;
        }
        Method method = null;
        try {
            method = Transformer.class.getMethod("reset", null);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.transformerResetMethod = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer takeTransformer() {
        List list = this.cache;
        synchronized (list) {
            if (this.cache.size() > 0) {
                return (Transformer)this.cache.remove(this.cache.size() - 1);
            }
        }
        return this.createNewTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTransformer(Transformer transformer) {
        Check.notNull(transformer, "transformer");
        if (this.transformerResetMethod == null) {
            return;
        }
        try {
            this.transformerResetMethod.invoke((Object)transformer, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (InvocationTargetException e) {
            return;
        }
        List list = this.cache;
        synchronized (list) {
            this.cache.add(transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer createNewTransformer() {
        Transformer transformer;
        Object object = this.factoryLock;
        synchronized (object) {
            if (this.factory == null) {
                this.factory = JAXPUtils.newTransformerFactory();
            }
            transformer = JAXPUtils.newTransformer(this.factory);
        }
        return transformer;
    }
}

