/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cfg;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.php.utils.collections.SetUtils;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternElementTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class LiveVariablesAnalysis {
    private final Map<CfgBlock, LiveVariables> liveVariablesPerBlock = new HashMap<CfgBlock, LiveVariables>();

    public static LiveVariablesAnalysis analyze(ControlFlowGraph cfg, SymbolTable symbols) {
        LiveVariablesAnalysis instance = new LiveVariablesAnalysis();
        instance.compute(cfg, symbols);
        return instance;
    }

    public LiveVariables getLiveVariables(CfgBlock block) {
        return this.liveVariablesPerBlock.get(block);
    }

    public Set<Symbol> getReadSymbols() {
        HashSet<Symbol> readAtLeastOnce = new HashSet<Symbol>();
        for (LiveVariables liveVariables : this.liveVariablesPerBlock.values()) {
            for (Map<Symbol, VariableUsage> symbolVariableUsageMap : liveVariables.variableUsagesPerElement.values()) {
                for (Map.Entry<Symbol, VariableUsage> symbolWithUsage : symbolVariableUsageMap.entrySet()) {
                    if (!symbolWithUsage.getValue().isRead) continue;
                    readAtLeastOnce.add(symbolWithUsage.getKey());
                }
            }
        }
        return readAtLeastOnce;
    }

    private void compute(ControlFlowGraph cfg, SymbolTable symbols) {
        cfg.blocks().forEach(block -> this.liveVariablesPerBlock.put((CfgBlock)block, LiveVariables.build(block, symbols)));
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>(cfg.blocks());
        while (!workList.isEmpty()) {
            CfgBlock currentBlock = (CfgBlock)workList.pop();
            LiveVariables liveVariables = this.liveVariablesPerBlock.get(currentBlock);
            boolean liveInHasChanged = liveVariables.propagate(this.liveVariablesPerBlock);
            if (!liveInHasChanged) continue;
            currentBlock.predecessors().forEach(workList::push);
        }
    }

    public static class LiveVariables {
        private final CfgBlock block;
        private final Map<Tree, Map<Symbol, VariableUsage>> variableUsagesPerElement;
        private final Set<Symbol> gen = new HashSet<Symbol>();
        private final Set<Symbol> kill = new HashSet<Symbol>();
        private Set<Symbol> in = new HashSet<Symbol>();
        private Set<Symbol> out = new HashSet<Symbol>();

        private LiveVariables(CfgBlock block) {
            this.block = block;
            this.variableUsagesPerElement = new HashMap<Tree, Map<Symbol, VariableUsage>>();
        }

        public Set<Symbol> getIn() {
            return Collections.unmodifiableSet(this.in);
        }

        public Set<Symbol> getOut() {
            return Collections.unmodifiableSet(this.out);
        }

        public Map<Symbol, VariableUsage> getVariableUsages(Tree tree) {
            return Collections.unmodifiableMap(this.variableUsagesPerElement.get(tree));
        }

        public Set<Symbol> getGen() {
            return Collections.unmodifiableSet(this.gen);
        }

        public Set<Symbol> getKill() {
            return Collections.unmodifiableSet(this.kill);
        }

        static LiveVariables build(CfgBlock block, SymbolTable symbols) {
            LiveVariables instance = new LiveVariables(block);
            instance.init(block, symbols);
            return instance;
        }

        private void init(CfgBlock block, SymbolTable symbols) {
            HashSet<Symbol> writtenOnly = new HashSet<Symbol>();
            for (Tree element : block.elements()) {
                Map<Symbol, VariableUsage> variableUsages = ReadWriteVisitor.getVariableUsages(element, symbols);
                this.variableUsagesPerElement.put(element, variableUsages);
                this.computeGenAndKill(writtenOnly, variableUsages);
            }
        }

        private void computeGenAndKill(Set<Symbol> writtenOnly, Map<Symbol, VariableUsage> variableUsages) {
            for (Map.Entry<Symbol, VariableUsage> variableUsage : variableUsages.entrySet()) {
                Symbol variable = variableUsage.getKey();
                VariableUsage usage = variableUsage.getValue();
                if (usage.isRead && !writtenOnly.contains(variable)) {
                    this.gen.add(variable);
                }
                if (!usage.isWrite) continue;
                this.kill.add(variable);
                if (usage.isRead) continue;
                writtenOnly.add(variable);
            }
        }

        boolean propagate(Map<CfgBlock, LiveVariables> liveVariablesPerBlock) {
            this.out.clear();
            this.block.successors().stream().map(liveVariablesPerBlock::get).map(LiveVariables::getIn).forEach(this.out::addAll);
            HashSet<Symbol> newIn = new HashSet<Symbol>(this.gen);
            newIn.addAll(SetUtils.difference(this.out, this.kill));
            boolean inHasChanged = !newIn.equals(this.in);
            this.in = newIn;
            return inHasChanged;
        }
    }

    public static final class VariableUsage {
        private boolean isRead = false;
        private boolean isWrite = false;

        public boolean isWrite() {
            return this.isWrite;
        }

        public boolean isRead() {
            return this.isRead;
        }
    }

    private static class ReadWriteVisitor
    extends PHPVisitorCheck {
        private final SymbolTable symbols;
        private final Map<Symbol, VariableUsage> variables = new HashMap<Symbol, VariableUsage>();

        ReadWriteVisitor(SymbolTable symbols) {
            this.symbols = symbols;
        }

        static Map<Symbol, VariableUsage> getVariableUsages(Tree tree, SymbolTable symbols) {
            ReadWriteVisitor visitor = new ReadWriteVisitor(symbols);
            tree.accept(visitor);
            return visitor.variables;
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            boolean isCompoundAssignment = !tree.is(Tree.Kind.ASSIGNMENT, Tree.Kind.NULL_COALESCING_ASSIGNMENT);
            boolean isUsedAsNamedParameterOrReturn = tree.getParent().is(Tree.Kind.CALL_ARGUMENT, Tree.Kind.RETURN_STATEMENT);
            boolean isNullCoalescingAssignment = tree.is(Tree.Kind.NULL_COALESCING_ASSIGNMENT);
            if (isCompoundAssignment || isUsedAsNamedParameterOrReturn || isNullCoalescingAssignment) {
                this.visitReadVariable(tree.variable());
            }
            if (!this.visitAssignedVariable(tree.variable())) {
                tree.variable().accept(this);
            }
            tree.value().accept(this);
        }

        @Override
        public void visitArrayAssignmentPatternElement(ArrayAssignmentPatternElementTree tree) {
            if (this.visitAssignedVariable(tree.variable())) {
                ExpressionTree key = tree.key();
                if (key != null) {
                    this.visitAssignedVariable(key);
                }
            } else {
                super.visitArrayAssignmentPatternElement(tree);
            }
        }

        @Override
        public void visitVariableIdentifier(VariableIdentifierTree tree) {
            this.visitReadVariable(tree);
            super.visitVariableIdentifier(tree);
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            this.visitReadVariable(tree);
            super.visitLiteral(tree);
        }

        @Override
        public void visitPrefixExpression(UnaryExpressionTree tree) {
            if (tree.is(Tree.Kind.PREFIX_INCREMENT) || tree.is(Tree.Kind.PREFIX_DECREMENT)) {
                this.visitUnaryExpression(tree);
            } else {
                super.visitPrefixExpression(tree);
            }
        }

        @Override
        public void visitPostfixExpression(UnaryExpressionTree tree) {
            if (tree.is(Tree.Kind.POSTFIX_INCREMENT) || tree.is(Tree.Kind.POSTFIX_DECREMENT)) {
                this.visitUnaryExpression(tree);
            } else {
                super.visitPostfixExpression(tree);
            }
        }

        private void visitUnaryExpression(UnaryExpressionTree tree) {
            tree.expression().accept(this);
            this.visitAssignedVariable(tree.expression());
        }

        private boolean visitAssignedVariable(Tree tree) {
            if (!tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                return false;
            }
            Symbol varSym = this.symbols.getSymbol(tree);
            if (ReadWriteVisitor.isLocalVariable(varSym)) {
                VariableUsage usage = this.variables.computeIfAbsent(varSym, s -> new VariableUsage());
                usage.isWrite = true;
                return true;
            }
            return false;
        }

        private void visitReadVariable(Tree tree) {
            Symbol varSym;
            if (tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                varSym = this.symbols.getSymbol(tree);
            } else if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                varSym = this.symbols.getSymbol(((LiteralTree)tree).token());
            } else {
                return;
            }
            if (ReadWriteVisitor.isLocalVariable(varSym)) {
                VariableUsage usage = this.variables.computeIfAbsent(varSym, s -> new VariableUsage());
                usage.isRead = true;
            }
        }

        private static boolean isLocalVariable(@Nullable Symbol symbol) {
            return symbol != null && (symbol.is(Symbol.Kind.VARIABLE) || symbol.is(Symbol.Kind.PARAMETER));
        }
    }
}

