/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1780")
public class ClosingTagInFullPHPFileCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1780";
    private static final String MESSAGE = "Remove this closing tag \"?>\".";
    private int inlineHTMLCounter = 0;
    private boolean isOnlyClosingTag = false;
    private SyntaxToken lastInlineHTMLToken = null;

    public void initScan() {
        this.inlineHTMLCounter = 0;
        this.isOnlyClosingTag = false;
        this.lastInlineHTMLToken = null;
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (token.is(Tree.Kind.INLINE_HTML_TOKEN)) {
            ++this.inlineHTMLCounter;
            this.isOnlyClosingTag = CheckUtils.isClosingTag(token);
            this.lastInlineHTMLToken = token;
        }
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.initScan();
        super.visitCompilationUnit(tree);
        if (this.inlineHTMLCounter == 1 && this.isOnlyClosingTag) {
            this.context().newIssue(this, this.lastInlineHTMLToken, MESSAGE);
        }
    }
}

