/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.sonar.sslr.api.typed.ActionParser;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.parser.PHPLexicalGrammar;
import org.sonar.php.parser.PHPParserBuilder;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S125")
public class CommentedOutCodeCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove this commented out code.";
    private static final Pattern MULTILINE_COMMENT_REPLACE = Pattern.compile("((/\\*\\*?)|(\\n\\s*\\*(?!/))|(\\*/))");
    private static final Pattern SINGLE_LINE_COMMENT_REPLACE = Pattern.compile("^((//)|(#))");
    private static final Pattern MULTIPLE_LINEBREAKS = Pattern.compile("\\R+");
    private static final String INNER_CLASS_CONTEXT = "class DummyClass{%s}";
    private static final String INNER_METHOD_CONTEXT = "class DummyClass{public function dummyMethod(){%s}}";
    private static final Tree.Kind[] TOP_STATEMENTS = new Tree.Kind[]{Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.GROUP_USE_STATEMENT};
    private static final ActionParser<Tree> PARSER = PHPParserBuilder.createParser(PHPLexicalGrammar.TOP_STATEMENT);
    private static final Deque<SyntaxTrivia> singleLineTrivias = new ArrayDeque<SyntaxTrivia>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        super.visitCompilationUnit(tree);
        this.checkSingleLineComments();
    }

    @Override
    public void visitTrivia(SyntaxTrivia trivia) {
        String comment = trivia.text();
        if (comment.startsWith("/*") && CommentedOutCodeCheck.isParsableCode(MULTILINE_COMMENT_REPLACE.matcher(comment).replaceAll(" "))) {
            this.context().newIssue(this, trivia, MESSAGE);
        }
        if (comment.startsWith("//") || comment.startsWith("#")) {
            this.collectSingleLineComment(trivia);
        }
        super.visitTrivia(trivia);
    }

    private void collectSingleLineComment(SyntaxTrivia trivia) {
        if (!singleLineTrivias.isEmpty() && CommentedOutCodeCheck.isNewCommentBlock(trivia)) {
            this.checkSingleLineComments();
        }
        singleLineTrivias.addLast(trivia);
    }

    private static boolean isNewCommentBlock(SyntaxTrivia trivia) {
        SyntaxTrivia prevTrivia = singleLineTrivias.peekLast();
        return prevTrivia.line() + 1 != trivia.line() || prevTrivia.text().charAt(0) != trivia.text().charAt(0);
    }

    private void checkSingleLineComments() {
        StringBuilder mergedSingleLineComment = new StringBuilder();
        singleLineTrivias.iterator().forEachRemaining(t -> mergedSingleLineComment.append(SINGLE_LINE_COMMENT_REPLACE.matcher(t.text().trim()).replaceAll("")));
        if (CommentedOutCodeCheck.isParsableCode(mergedSingleLineComment.toString())) {
            SyntaxTrivia firstTrivia = singleLineTrivias.peekFirst();
            SyntaxTrivia lastTrivia = singleLineTrivias.peekLast();
            this.context().newIssue(this, firstTrivia, lastTrivia, MESSAGE);
        }
        singleLineTrivias.clear();
    }

    private static boolean isParsableCode(String possibleCode) {
        if (MULTIPLE_LINEBREAKS.matcher(possibleCode).replaceAll("").trim().isEmpty()) {
            return false;
        }
        try {
            ClassDeclarationTree classDeclaration = (ClassDeclarationTree)PARSER.parse(String.format(INNER_METHOD_CONTEXT, possibleCode));
            return !((BlockTree)((MethodDeclarationTree)classDeclaration.members().get(0)).body()).statements().get(0).is(Tree.Kind.LABEL);
        }
        catch (Exception classDeclaration) {
            try {
                ClassDeclarationTree parsedCode = (ClassDeclarationTree)PARSER.parse(String.format(INNER_CLASS_CONTEXT, possibleCode));
                return !parsedCode.members().isEmpty();
            }
            catch (Exception parsedCode) {
                try {
                    Tree tree = PARSER.parse(possibleCode);
                    return tree.is(TOP_STATEMENTS);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }
}

