/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.php.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S126")
public class ElseIfWithoutElseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S126";
    private static final String MESSAGE = "Add the missing \"else\" clause.";
    private final Set<Tree> exclusivelyExitBodies = new HashSet<Tree>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        super.visitCompilationUnit(tree);
        this.exclusivelyExitBodies.clear();
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        List<ElseifClauseTree> elseifClauses = tree.elseifClauses();
        ArrayList<StatementTree> conditionBodies = new ArrayList<StatementTree>(tree.statements());
        if (tree.elseClause() == null && !elseifClauses.isEmpty()) {
            elseifClauses.forEach(c -> conditionBodies.addAll(c.statements()));
            if (!this.hasExclusivelyExitBodies(conditionBodies)) {
                ElseifClauseTree lastElseIf = elseifClauses.get(elseifClauses.size() - 1);
                this.context().newIssue(this, lastElseIf.elseifToken(), MESSAGE);
            }
        }
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        super.visitElseClause(tree);
        IfStatementTree parentIf = (IfStatementTree)tree.getParent();
        if (tree.statements().get(0).is(Tree.Kind.IF_STATEMENT)) {
            IfStatementTree nestedIf = (IfStatementTree)tree.statements().get(0);
            if (nestedIf.elseClause() == null && nestedIf.elseifClauses().isEmpty()) {
                ArrayList<StatementTree> bodyStatements = new ArrayList<StatementTree>(parentIf.statements());
                bodyStatements.addAll(nestedIf.statements());
                if (!this.hasExclusivelyExitBodies(bodyStatements)) {
                    this.context().newIssue(this, tree.elseToken(), nestedIf.ifToken(), MESSAGE);
                }
            }
        } else {
            ArrayList<StatementTree> bodyStatements = new ArrayList<StatementTree>(tree.statements());
            bodyStatements.addAll(parentIf.statements());
            if (this.hasExclusivelyExitBodies(bodyStatements)) {
                this.exclusivelyExitBodies.add(parentIf);
            }
        }
    }

    private boolean hasExclusivelyExitBodies(List<StatementTree> statements) {
        return !statements.isEmpty() && statements.stream().allMatch(s -> {
            ConditionBodyVisitor conditionBody = new ConditionBodyVisitor();
            s.accept(conditionBody);
            return conditionBody.hasExitStatement;
        });
    }

    private class ConditionBodyVisitor
    extends PHPVisitorCheck {
        boolean hasExitStatement = false;

        private ConditionBodyVisitor() {
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            this.hasExitStatement = true;
        }

        @Override
        public void visitBreakStatement(BreakStatementTree tree) {
            this.hasExitStatement = true;
        }

        @Override
        public void visitContinueStatement(ContinueStatementTree tree) {
            this.hasExitStatement = true;
        }

        @Override
        public void visitThrowStatement(ThrowStatementTree tree) {
            this.hasExitStatement = true;
        }

        @Override
        public void visitIfStatement(IfStatementTree tree) {
            if (ElseIfWithoutElseCheck.this.exclusivelyExitBodies.contains(tree)) {
                this.hasExitStatement = true;
            }
        }
    }
}

