/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1313")
public class HardCodedIpAddressCheck
extends PHPVisitorCheck {
    private static final String LOOPBACK_IPV4 = "^127(?:\\.\\d+){0,2}\\.\\d+$";
    private static final String LOOPBACK_IPV6 = "^(?:0*:){0,7}?:?0*1$";
    private static final String LOOPBACK_IPV4_MAPPED_TO_IPV6 = "^(::(?i)ffff(:0{1,4})?):127$";
    private static final Pattern LOOPBACK_IP = Pattern.compile("^127(?:\\.\\d+){0,2}\\.\\d+$|^(?:0*:){0,7}?:?0*1$|^(::(?i)ffff(:0{1,4})?):127$");
    private static final String PROTOCOL = "((\\w+:)?\\/\\/)?";
    public static final String IP_V4 = "(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}(?!\\d)";
    public static final String IP_V6 = "\\[?(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7})|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(?![\\d\\w:])";
    private static final Pattern IP_PATTERN = Pattern.compile(String.format("%s(?<ip>((%s)|(%s)))", "((\\w+:)?\\/\\/)?", "(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}(?!\\d)", "\\[?(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7})|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(?![\\d\\w:])"));
    private static final List<String> RESERVED_IP_PREFIXES = List.of("192.0.2.", "198.51.100.", "203.0.113.", "2001:0db8:", "2001:db8:");
    private static final String MESSAGE = "Make sure using this hardcoded IP address is safe here.";
    private static final String BROADCAST_IPV4 = "255.255.255.255";

    @Override
    public void visitLiteral(LiteralTree tree) {
        String ip;
        String literalValue;
        Matcher matcher;
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && (matcher = IP_PATTERN.matcher(literalValue = CheckUtils.trimQuotes(tree.value()))).find() && matcher.start() == 0 && HardCodedIpAddressCheck.isSensitive(ip = matcher.group("ip"))) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitLiteral(tree);
    }

    private static boolean isSensitive(String ip) {
        return !HardCodedIpAddressCheck.isLoopback(ip) && !HardCodedIpAddressCheck.isBroadcast(ip) && !HardCodedIpAddressCheck.isReservedIP(ip);
    }

    private static boolean isLoopback(String ip) {
        ip = ip.replace("[", "");
        return LOOPBACK_IP.matcher(ip).find();
    }

    private static boolean isBroadcast(String ip) {
        return BROADCAST_IPV4.equals(ip);
    }

    private static boolean isReservedIP(String ip) {
        return RESERVED_IP_PREFIXES.stream().anyMatch(ip::startsWith);
    }
}

