/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerBracketTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2053")
public class HashFunctionCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Use an unpredictable salt value.";
    private static final String MESSAGE_MISSING_SALT = "Provide a cryptographically strong salt parameter.";
    private static final String USE_DEFAULT_SALT_MESSAGE = "Use the salt that is generated by default.";
    private boolean containsPasswordHashFunction;
    private List<Tree> passwordHashSaltTrees = new ArrayList<Tree>();

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if ("hash_pbkdf2".equals(functionName)) {
            ExpressionTree saltArgumentValue;
            Optional<CallArgumentTree> saltArgument = CheckUtils.argument(tree, "salt", 2);
            if (saltArgument.isPresent() && this.isPredictable(saltArgumentValue = saltArgument.get().value())) {
                this.context().newIssue(this, saltArgumentValue, MESSAGE);
            }
        } else if ("crypt".equals(functionName)) {
            Optional<CallArgumentTree> saltArgument = CheckUtils.argument(tree, "salt", 1);
            if (!saltArgument.isPresent()) {
                this.context().newIssue(this, tree, MESSAGE_MISSING_SALT);
            } else {
                ExpressionTree saltArgumentValue = saltArgument.get().value();
                if (this.isPredictable(saltArgumentValue)) {
                    this.context().newIssue(this, saltArgumentValue, MESSAGE);
                }
            }
        } else if ("password_hash".equals(functionName)) {
            this.containsPasswordHashFunction = true;
        }
        super.visitFunctionCall(tree);
    }

    private boolean isPredictable(ExpressionTree tree) {
        Optional<ExpressionTree> uniqueAssignedValue;
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            return true;
        }
        if (tree.is(Tree.Kind.ARRAY_ACCESS)) {
            ExpressionTree array = ((ArrayAccessTree)tree).object();
            return array.is(Tree.Kind.VARIABLE_IDENTIFIER) && CheckUtils.SUPERGLOBALS.contains(((VariableIdentifierTree)array).text());
        }
        if (tree.is(Tree.Kind.VARIABLE_IDENTIFIER) && (uniqueAssignedValue = CheckUtils.uniqueAssignedValue((VariableIdentifierTree)tree)).isPresent()) {
            return this.isPredictable(uniqueAssignedValue.get());
        }
        return false;
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.passwordHashSaltTrees.clear();
        super.visitCompilationUnit(tree);
        if (this.containsPasswordHashFunction && !this.passwordHashSaltTrees.isEmpty()) {
            this.passwordHashSaltTrees.forEach(salt -> this.context().newIssue(this, (Tree)salt, USE_DEFAULT_SALT_MESSAGE));
        }
    }

    @Override
    public void visitArrayInitializerBracket(ArrayInitializerBracketTree tree) {
        tree.arrayPairs().stream().map(ArrayPairTree::key).filter(Objects::nonNull).filter(key -> key.is(Tree.Kind.REGULAR_STRING_LITERAL) && "salt".equals(CheckUtils.trimQuotes((LiteralTree)key))).forEach(this.passwordHashSaltTrees::add);
        super.visitArrayInitializerBracket(tree);
    }
}

