/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.declaration.ClassNamespaceNameTreeImpl;
import org.sonar.php.tree.impl.expression.FunctionCallTreeImpl;
import org.sonar.php.tree.symbols.HasClassSymbol;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.CallableConvertTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.UseTraitDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1144")
public class UnusedPrivateMethodCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove this unused private \"%s\" method.";
    private static final Pattern USES_PHPDOC_PATTERN = Pattern.compile("@uses\\s+(\\w+::)?(\\w+)");
    private static final List<String> CALL_USER_FUNCTIONS = List.of("call_user_func_array", "call_user_func");
    private final List<String> stringLiterals = new ArrayList<String>();
    private final List<String> dynamicUsedMethods = new ArrayList<String>();
    private final List<String> methodsUsedInFirstClassCallables = new ArrayList<String>();

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.stringLiterals.clear();
        this.dynamicUsedMethods.clear();
        this.methodsUsedInFirstClassCallables.clear();
        super.visitClassDeclaration(tree);
        if (tree.is(Tree.Kind.CLASS_DECLARATION, Tree.Kind.ENUM_DECLARATION)) {
            this.checkClass(tree);
        }
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        ((PHPTree)((Object)tree)).getFirstToken().trivias().stream().flatMap(trivia -> USES_PHPDOC_PATTERN.matcher(trivia.text()).results()).map(result -> result.group(2)).map(methodName -> methodName.toLowerCase(Locale.ROOT)).forEach(this.dynamicUsedMethods::add);
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitCallableConvert(CallableConvertTree tree) {
        MemberAccessTree memberAccessTree;
        if (tree.expression().is(Tree.Kind.OBJECT_MEMBER_ACCESS) && UnusedPrivateMethodCheck.isThis((memberAccessTree = (MemberAccessTree)tree.expression()).object()) && memberAccessTree.member().is(Tree.Kind.NAME_IDENTIFIER)) {
            this.methodsUsedInFirstClassCallables.add(((NameIdentifierTree)memberAccessTree.member()).text().toLowerCase(Locale.ROOT));
        }
        super.visitCallableConvert(tree);
    }

    private void checkClass(ClassTree tree) {
        Scope classScope = this.context().symbolTable().getScopeFor(tree);
        for (Symbol methodSymbol : classScope.getSymbols(Symbol.Kind.FUNCTION)) {
            boolean isUnusedMethodWithNarrowVisibility = (methodSymbol.hasModifier("private") || UnusedPrivateMethodCheck.isProtectedEnumMethod(tree, methodSymbol)) && methodSymbol.usages().isEmpty();
            if (!isUnusedMethodWithNarrowVisibility || this.dynamicUsedMethods.contains(methodSymbol.name()) || this.methodsUsedInFirstClassCallables.contains(methodSymbol.name()) || UnusedPrivateMethodCheck.isConstructor(methodSymbol.declaration(), tree) || UnusedPrivateMethodCheck.isMagicMethod(methodSymbol.name()) || this.isUsedInStringLiteral(methodSymbol) || UnusedPrivateMethodCheck.isMagicMethodCallDefined(tree)) continue;
            this.context().newIssue(this, methodSymbol.declaration(), String.format(MESSAGE, methodSymbol.name()));
        }
    }

    private static boolean isMagicMethodCallDefined(ClassTree tree) {
        if (tree instanceof ClassDeclarationTree) {
            ClassDeclarationTree classDeclaration = (ClassDeclarationTree)tree;
            Optional<ClassMemberTree> magicMethodCall = UnusedPrivateMethodCheck.findMagicMethodCall(classDeclaration);
            if (magicMethodCall.isPresent() && UnusedPrivateMethodCheck.containsCallUserFunction(magicMethodCall.get())) {
                return true;
            }
            Optional<ClassSymbol> superClass = ((HasClassSymbol)((Object)tree)).symbol().superClass();
            if (superClass.isPresent() && UnusedPrivateMethodCheck.containsSuperClassCallMethod(superClass.get())) {
                return true;
            }
            return UnusedPrivateMethodCheck.containsTraitWithMagicMethodCall(tree);
        }
        return false;
    }

    private static Optional<ClassMemberTree> findMagicMethodCall(ClassDeclarationTree tree) {
        return tree.members().stream().filter(MethodDeclarationTree.class::isInstance).filter(method -> "__call".equals(((MethodDeclarationTree)method).name().text())).findFirst();
    }

    private static boolean containsCallUserFunction(ClassMemberTree magicMethodCall) {
        return TreeUtils.descendants(magicMethodCall, FunctionCallTree.class).anyMatch(expression -> {
            String functionName = ((FunctionCallTreeImpl)expression).symbol().qualifiedName().simpleName().toLowerCase(Locale.ROOT);
            return CALL_USER_FUNCTIONS.contains(functionName);
        });
    }

    private static boolean containsSuperClassCallMethod(ClassSymbol tree) {
        if (UnusedPrivateMethodCheck.containsMagicMethodCall(tree)) {
            return true;
        }
        Optional<ClassSymbol> superClass = tree.superClass();
        if (superClass.isPresent()) {
            return UnusedPrivateMethodCheck.containsSuperClassCallMethod(superClass.get());
        }
        return false;
    }

    private static boolean containsTraitWithMagicMethodCall(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(Tree.Kind.USE_TRAIT_DECLARATION)).map(member -> ((UseTraitDeclarationTree)member).traits()).flatMap(Collection::stream).filter(ClassNamespaceNameTreeImpl.class::isInstance).map(trait -> ((ClassNamespaceNameTreeImpl)trait).symbol()).anyMatch(UnusedPrivateMethodCheck::containsMagicMethodCall);
    }

    private static boolean containsMagicMethodCall(ClassSymbol tree) {
        return tree.declaredMethods().stream().anyMatch(m -> m.name().startsWith("__call"));
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.stringLiterals.clear();
        this.dynamicUsedMethods.clear();
        this.methodsUsedInFirstClassCallables.clear();
        super.visitAnonymousClass(tree);
        this.checkClass(tree);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            this.stringLiterals.add(CheckUtils.trimQuotes(tree).toLowerCase(Locale.ROOT));
        }
    }

    private static boolean isProtectedEnumMethod(ClassTree tree, Symbol methodSymbol) {
        return tree.is(Tree.Kind.ENUM_DECLARATION) && methodSymbol.hasModifier("protected");
    }

    private boolean isUsedInStringLiteral(Symbol methodSymbol) {
        for (String stringLiteral : this.stringLiterals) {
            if (!stringLiteral.contains(methodSymbol.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isConstructor(IdentifierTree methodName, ClassTree classDec) {
        MethodDeclarationTree constructor = classDec.fetchConstructor();
        return constructor != null && constructor.name().equals(methodName);
    }

    private static boolean isMagicMethod(String methodName) {
        return methodName.startsWith("__");
    }

    private static boolean isThis(Tree object) {
        return object.is(Tree.Kind.VARIABLE_IDENTIFIER) && "$this".equals(((VariableIdentifierTree)object).text());
    }
}

