/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.regex;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.php.regex.PhpRegexCheck;
import org.sonar.php.regex.PhpRegexUtils;
import org.sonar.php.regex.RegexCheckContext;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.CheckContext;
import org.sonar.plugins.php.api.visitors.PhpIssue;
import org.sonar.plugins.php.api.visitors.PreciseIssue;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public abstract class AbstractRegexCheck
extends FunctionUsageCheck
implements PhpRegexCheck {
    public static final int PCRE_CASELESS = 2;
    public static final int PCRE_MULTILINE = 8;
    public static final int PCRE_DOTALL = 32;
    public static final int PCRE_EXTENDED = 4;
    public static final int PCRE_UTF8 = 256;
    protected static final Pattern DELIMITER_PATTERN = Pattern.compile("^[^a-zA-Z\\d\\r\\n\\t\\f\\v]");
    protected static final Set<String> REGEX_FUNCTIONS = Set.of("preg_replace", "preg_match", "preg_filter", "preg_replace_callback", "preg_split", "preg_match_all");
    private RegexCheckContext regexContext;
    private final Set<RegexSyntaxElement> reportedRegexTrees = new HashSet<RegexSyntaxElement>();

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return REGEX_FUNCTIONS;
    }

    @Override
    public List<PhpIssue> analyze(CheckContext context) {
        this.regexContext = (RegexCheckContext)((Object)context);
        this.reportedRegexTrees.clear();
        return super.analyze(context);
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        CheckUtils.argumentValue(tree, "pattern", 0).flatMap(AbstractRegexCheck::getLiteral).filter(this::hasValidDelimiters).map(pattern -> this.regexForLiteral(AbstractRegexCheck.getFlagSet(pattern), (LiteralTree)pattern)).ifPresent(result -> this.checkRegex((RegexParseResult)result, tree));
    }

    static FlagSet getFlagSet(LiteralTree literalTree) {
        String pattern = AbstractRegexCheck.trimPattern(literalTree);
        Character endDelimiter = PhpRegexUtils.getEndDelimiter(pattern);
        String patternModifiers = pattern.substring(pattern.lastIndexOf(endDelimiter.charValue()) + 1);
        FlagSet flags = new FlagSet();
        for (char modifier : patternModifiers.toCharArray()) {
            Optional.ofNullable(AbstractRegexCheck.parseModifier(modifier)).ifPresent(flags::add);
        }
        return flags;
    }

    static Optional<LiteralTree> getLiteral(ExpressionTree expr) {
        if (expr.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            return Optional.of((LiteralTree)expr);
        }
        if (expr.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)expr).flatMap(AbstractRegexCheck::getLiteral);
        }
        return Optional.empty();
    }

    protected boolean hasValidDelimiters(LiteralTree tree) {
        String pattern = AbstractRegexCheck.trimPattern(tree);
        if (pattern.length() >= 2) {
            Matcher m = DELIMITER_PATTERN.matcher(pattern);
            return m.find() && AbstractRegexCheck.containsEndDelimiter(pattern.substring(1), Character.valueOf(m.group().charAt(0)));
        }
        return false;
    }

    protected static String trimPattern(LiteralTree tree) {
        return CheckUtils.trimQuotes(tree).trim();
    }

    protected static boolean containsEndDelimiter(String croppedPattern, Character startDelimiter) {
        return croppedPattern.indexOf(PhpRegexUtils.BRACKET_DELIMITERS.getOrDefault(startDelimiter, startDelimiter).charValue()) >= 0;
    }

    protected final RegexParseResult regexForLiteral(FlagSet flags, LiteralTree literals) {
        return this.regexContext.regexForLiteral(flags, literals);
    }

    protected abstract void checkRegex(RegexParseResult var1, FunctionCallTree var2);

    protected void newIssue(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexIssueLocation> secondaries) {
        if (this.reportedRegexTrees.add(regexTree)) {
            PreciseIssue issue = this.regexContext.newIssue(this, regexTree, message);
            secondaries.stream().map(PhpRegexCheck.PhpRegexIssueLocation::new).forEach(issue::secondary);
            if (cost != null) {
                issue.cost(cost.intValue());
            }
        }
    }

    protected final void newIssue(Tree tree, String message, @Nullable Integer cost, List<RegexIssueLocation> secondaries) {
        PreciseIssue issue = this.newIssue(tree, message);
        secondaries.stream().map(PhpRegexCheck.PhpRegexIssueLocation::new).forEach(issue::secondary);
        if (cost != null) {
            issue.cost(cost.intValue());
        }
    }

    @CheckForNull
    private static Integer parseModifier(char ch) {
        return switch (ch) {
            case 'i' -> 2;
            case 'm' -> 8;
            case 's' -> 32;
            case 'u' -> 256;
            case 'x' -> 4;
            default -> null;
        };
    }
}

