/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S4433")
public class LDAPAuthenticatedConnectionCheck
extends FunctionUsageCheck {
    private static final String MESSAGE = "Provide username and password to authenticate the connection.";

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Set.of("ldap_bind");
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        if (this.argumentIsNullOrEmptyString(tree, "bind_rdn", 1) || this.argumentIsNullOrEmptyString(tree, "bind_password", 2)) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private boolean argumentIsNullOrEmptyString(FunctionCallTree tree, String argumentName, int argumentIndex) {
        Optional<CallArgumentTree> argument = CheckUtils.argument(tree, argumentName, argumentIndex);
        if (argument.isPresent()) {
            ExpressionTree argumentValue = CheckUtils.assignedValue(argument.get().value());
            return CheckUtils.isNullOrEmptyString(argumentValue);
        }
        return true;
    }
}

