/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils.argumentmatching;

import java.util.Optional;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.argumentmatching.ArgumentMatcher;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public abstract class FunctionArgumentCheck
extends PHPVisitorCheck {
    protected abstract void createIssue(ExpressionTree var1);

    public void checkArgument(FunctionCallTree tree, String expectedFunctionName, ArgumentMatcher ... expectedArgument) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (expectedFunctionName.equals(functionName)) {
            for (ArgumentMatcher argumentMatcher : expectedArgument) {
                if ((argumentMatcher.getName() != null || argumentMatcher.getPosition() < tree.callArguments().size()) && this.verifyArgument(tree, argumentMatcher)) continue;
                return;
            }
        }
    }

    public boolean checkArgumentAbsence(FunctionCallTree tree, String expectedFunctionName, int position) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (expectedFunctionName.equals(functionName) && position >= tree.callArguments().size()) {
            this.createIssue(tree);
            return true;
        }
        return false;
    }

    private boolean verifyArgument(FunctionCallTree tree, ArgumentMatcher argumentMatcher) {
        Optional<CallArgumentTree> optionalArgument = CheckUtils.argument(tree, argumentMatcher.getName(), argumentMatcher.getPosition());
        if (optionalArgument.isPresent()) {
            IssueRaiser issueRaiser;
            ExpressionTree argument = optionalArgument.get().value();
            ExpressionTree argumentValue = CheckUtils.assignedValue(argument);
            boolean matchesValues = argumentMatcher.matches(argumentValue);
            if (argumentMatcher instanceof IssueRaiser && (issueRaiser = (IssueRaiser)((Object)argumentMatcher)).shouldRaiseIssue(matchesValues, argumentValue)) {
                this.createIssue(argument);
            }
            return matchesValues;
        }
        return false;
    }

    public static interface IssueRaiser {
        public boolean shouldRaiseIssue(boolean var1, ExpressionTree var2);
    }
}

