/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils.type;

import java.util.function.Predicate;
import org.sonar.php.checks.utils.type.TreeValues;
import org.sonar.php.checks.utils.type.TypePredicateList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;

public class ArrayAccess
implements Predicate<TreeValues> {
    private final TypePredicateList nestedPredicates;

    public ArrayAccess(Predicate<TreeValues> ... nestedPredicates) {
        this.nestedPredicates = new TypePredicateList(nestedPredicates);
    }

    @Override
    public boolean test(TreeValues possibleValues) {
        for (ExpressionTree tree : possibleValues.values) {
            if ((!tree.is(Tree.Kind.ARRAY_ACCESS) || !this.matches(possibleValues, (ArrayAccessTree)tree)) && (!tree.getParent().is(Tree.Kind.FOREACH_STATEMENT) || !this.matches(possibleValues, tree, (ForEachStatementTree)tree.getParent()))) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(TreeValues possibleValues, ArrayAccessTree arrayAccess) {
        return this.nestedPredicates.test(possibleValues.lookupPossibleValues(arrayAccess.object()));
    }

    protected boolean matches(TreeValues possibleValues, ExpressionTree value, ForEachStatementTree forEachStatementTree) {
        return forEachStatementTree.value() == value && this.nestedPredicates.test(possibleValues.lookupPossibleValues(forEachStatementTree.expression()));
    }
}

