/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Set;
import org.sonar.php.checks.CheckBundle;
import org.sonar.php.checks.CheckBundlePart;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

public class WordPressForceSslCheckPart
extends WordPressConfigVisitor
implements CheckBundlePart {
    private static final String MESSAGE = "Using non SSL protocol is insecure. Force using SSL protocol instead.";
    private CheckBundle bundle;

    @Override
    protected Set<String> configsToVisit() {
        return Set.of("FORCE_SSL_ADMIN", "FORCE_SSL_LOGIN");
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        WordPressForceSslCheckPart.configValue(config).filter(CheckUtils::isFalseValue).ifPresent(v -> this.context().newIssue(this.getBundle(), config, MESSAGE));
    }

    @Override
    public void setBundle(CheckBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public CheckBundle getBundle() {
        return this.bundle;
    }
}

