/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.symbols;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.php.symbols.FunctionSymbolIndex;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.MethodSymbolData;
import org.sonar.php.symbols.Trilean;
import org.sonar.php.symbols.Visibility;
import org.sonar.php.tree.symbols.QualifiedNames;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;

public class MethodSymbolImpl
extends FunctionSymbolIndex.FunctionSymbolImpl
implements MethodSymbol {
    private final MethodSymbolData data;
    private final ClassSymbol owner;
    private Trilean isOverriding;

    public MethodSymbolImpl(MethodSymbolData data, ClassSymbol owner) {
        super(new FunctionSymbolData(data.location(), data.qualifiedName(), data.parameters(), data.properties(), data.returnType()));
        this.data = data;
        this.owner = owner;
    }

    @Override
    public Visibility visibility() {
        return this.data.visibility();
    }

    @Override
    public String name() {
        return this.data.name();
    }

    @Override
    public QualifiedName qualifiedName() {
        return QualifiedNames.memberName(this.owner.qualifiedName(), this.name(), Symbol.Kind.FUNCTION);
    }

    @Override
    public Trilean isOverriding() {
        if (this.isOverriding == null) {
            this.isOverriding = this.computeIsOverriding();
        }
        return this.isOverriding;
    }

    private Trilean computeIsOverriding() {
        if (this.visibility().equals((Object)Visibility.PRIVATE) || this.name().equals("__construct")) {
            return Trilean.FALSE;
        }
        ArrayDeque<ClassSymbol> workList = new ArrayDeque<ClassSymbol>();
        HashSet<ClassSymbol> visitedClasses = new HashSet<ClassSymbol>();
        visitedClasses.add(this.owner);
        MethodSymbolImpl.pushOnIsOverridingWorkList(this.owner, workList);
        boolean isUnknown = false;
        while (!workList.isEmpty()) {
            ClassSymbol visitedClass = (ClassSymbol)workList.removeLast();
            if (!visitedClasses.add(visitedClass)) continue;
            if (visitedClass.isUnknownSymbol()) {
                isUnknown = true;
                continue;
            }
            MethodSymbol methodSymbol = visitedClass.getDeclaredMethod(this.name());
            if (!methodSymbol.isUnknownSymbol() && !methodSymbol.visibility().equals((Object)Visibility.PRIVATE)) {
                return Trilean.TRUE;
            }
            MethodSymbolImpl.pushOnIsOverridingWorkList(visitedClass, workList);
        }
        if (isUnknown) {
            return Trilean.UNKNOWN;
        }
        return Trilean.FALSE;
    }

    private static void pushOnIsOverridingWorkList(ClassSymbol classSymbol, Deque<ClassSymbol> workList) {
        classSymbol.superClass().ifPresent(workList::add);
        workList.addAll(classSymbol.implementedInterfaces());
    }

    @Override
    public Trilean isAbstract() {
        return this.data.isAbstract() ? Trilean.TRUE : Trilean.FALSE;
    }

    @Override
    public Trilean isTestMethod() {
        return this.data.isTestMethod() ? Trilean.TRUE : Trilean.FALSE;
    }

    @Override
    public ClassSymbol owner() {
        return this.owner;
    }
}

