/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Iterator;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class AssignmentByReferenceTreeImpl
extends PHPTree
implements AssignmentExpressionTree {
    private static final Tree.Kind KIND = Tree.Kind.ASSIGNMENT_BY_REFERENCE;
    private final ExpressionTree variable;
    private final InternalSyntaxToken equalToken;
    private final InternalSyntaxToken ampersandToken;
    private final ExpressionTree value;

    public AssignmentByReferenceTreeImpl(ExpressionTree variable, InternalSyntaxToken equalToken, InternalSyntaxToken ampersandToken, ExpressionTree value) {
        this.variable = variable;
        this.equalToken = equalToken;
        this.ampersandToken = ampersandToken;
        this.value = value;
    }

    @Override
    public ExpressionTree variable() {
        return this.variable;
    }

    @Override
    public String operator() {
        return this.equalToken.text() + this.ampersandToken.text();
    }

    public SyntaxToken equalToken() {
        return this.equalToken;
    }

    public SyntaxToken ampersandToken() {
        return this.ampersandToken;
    }

    @Override
    public ExpressionTree value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.iteratorOf(this.variable, this.equalToken, this.ampersandToken, this.value);
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitAssignmentExpression(this);
    }
}

