/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.utils.Preconditions;
import org.sonar.php.parser.PHPLexicalGrammar;
import org.sonar.php.parser.PHPParserBuilder;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.HeredocStringLiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class HeredocStringLiteralTreeImpl
extends PHPTree
implements HeredocStringLiteralTree {
    private final SyntaxToken openingToken;
    private final List<ExpressionTree> elements;
    private final SyntaxToken closingToken;
    private static final Pattern pattern = Pattern.compile("(?s)(<<<[ \t\u000b\f]*+\"?([^\r\n'\"]++)\"?(?:\r\n?+|\n))(?:(.*?)(?:\r\n?+|\n))?[ \t]*+\\2(?![[a-zA-Z_\\x7f-\\xff][0-9]])");

    public HeredocStringLiteralTreeImpl(SyntaxToken tmpHeredocToken) {
        int contentEndIndex;
        String tokenText = tmpHeredocToken.text();
        Matcher matcher = pattern.matcher(tokenText);
        Preconditions.checkArgument(matcher.matches());
        int openingTagEndIndex = matcher.end(1);
        String content = matcher.group(3);
        int contentStartIndex = matcher.start(3);
        int n = contentEndIndex = contentStartIndex == -1 ? openingTagEndIndex : matcher.end(3);
        if (content != null && content.length() > 0) {
            HeredocBody heredoc = (HeredocBody)PHPParserBuilder.createParser(PHPLexicalGrammar.HEREDOC_BODY, tmpHeredocToken.line()).parse(content);
            this.elements = heredoc.expressions();
        } else {
            this.elements = Collections.emptyList();
        }
        int startIndex = ((InternalSyntaxToken)tmpHeredocToken).startIndex();
        SyntaxToken tokenBeforeClosingToken = this.openingToken = new InternalSyntaxToken(tmpHeredocToken.line(), tmpHeredocToken.column(), tokenText.substring(0, openingTagEndIndex), tmpHeredocToken.trivias(), startIndex, false);
        if (!this.elements.isEmpty()) {
            tokenBeforeClosingToken = ((PHPTree)((Object)this.elements.get(this.elements.size() - 1))).getLastToken();
        }
        String closingTag = tokenText.substring(contentEndIndex);
        this.closingToken = new InternalSyntaxToken(tokenBeforeClosingToken.endLine(), tokenBeforeClosingToken.endColumn(), closingTag, Collections.emptyList(), startIndex + tokenText.length() - closingTag.length(), false);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.openingToken), this.elements.iterator(), IteratorUtils.iteratorOf(this.closingToken));
    }

    @Override
    public SyntaxToken openingToken() {
        return this.openingToken;
    }

    @Override
    public List<ExpandableStringCharactersTree> strings() {
        return this.elements.stream().filter(ExpandableStringCharactersTree.class::isInstance).map(ExpandableStringCharactersTree.class::cast).toList();
    }

    @Override
    public List<ExpressionTree> expressions() {
        return this.elements.stream().filter(input -> !input.is(Tree.Kind.HEREDOC_STRING_CHARACTERS)).toList();
    }

    @Override
    public SyntaxToken closingToken() {
        return this.closingToken;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitHeredoc(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.HEREDOC_LITERAL;
    }

    public static class HeredocBody
    extends PHPTree {
        private final List<ExpressionTree> expressions;

        public HeredocBody(List<ExpressionTree> expressions) {
            this.expressions = expressions;
        }

        @Override
        public Tree.Kind getKind() {
            throw new UnsupportedOperationException("Used only internally for building the tree");
        }

        public List<ExpressionTree> expressions() {
            return this.expressions;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public void accept(VisitorCheck visitor) {
            throw new UnsupportedOperationException("Used only internally for building the tree");
        }
    }
}

