/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    @CheckForNull
    public static <T> T getLast(List<T> list, @Nullable T defaultValue) {
        return list.isEmpty() ? defaultValue : list.get(list.size() - 1);
    }

    public static <T> T getOnlyElement(List<T> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new IllegalArgumentException(String.format("Expected list of size 1, but was list of size %d.", list.size()));
    }

    @SafeVarargs
    public static <T> List<T> concat(Collection<? extends T> ... collections) {
        ArrayList<? extends T> concatenatedList = new ArrayList<T>();
        for (Collection<? extends T> collection : collections) {
            concatenatedList.addAll(collection);
        }
        return concatenatedList;
    }

    @SafeVarargs
    public static <T> List<T> merge(Collection<? extends T> ... collections) {
        return ListUtils.concat(collections).stream().distinct().toList();
    }

    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }
}

