/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import com.ctc.wstx.exc.WstxIOException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.plugins.php.reports.phpunit.xml.TestCase;
import org.sonar.plugins.php.reports.phpunit.xml.TestSuite;
import org.sonar.plugins.php.reports.phpunit.xml.TestSuites;
import org.sonarsource.analyzer.commons.xml.ParseException;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;

public class JUnitLogParserForPhpUnit {
    public TestSuites parse(File report) throws ParseException, IOException {
        try {
            return JUnitLogParserForPhpUnit.processRoot(report, JUnitLogParserForPhpUnit.inputFactory());
        }
        catch (WstxIOException e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    public static SMInputFactory inputFactory() {
        return new SMInputFactory(SafetyFactory.createXMLInputFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TestSuites processRoot(File file, SMInputFactory inputFactory) throws XMLStreamException {
        SMHierarchicCursor rootCursor = null;
        try {
            rootCursor = inputFactory.rootElementCursor(file);
            rootCursor.advance();
            if (!"testsuites".equals(rootCursor.getLocalName())) {
                throw new XMLStreamException("Report should start with <testsuites>");
            }
            SMInputCursor childCursor = rootCursor.childElementCursor("testsuite");
            ArrayList<TestSuite> testSuites = new ArrayList<TestSuite>();
            while (childCursor.getNext() != null) {
                testSuites.add(JUnitLogParserForPhpUnit.processTestSuite(childCursor));
            }
            TestSuites testSuites2 = new TestSuites(testSuites);
            return testSuites2;
        }
        finally {
            if (rootCursor != null) {
                rootCursor.getStreamReader().closeCompletely();
            }
        }
    }

    private static TestSuite processTestSuite(SMInputCursor cursor) throws XMLStreamException {
        String name = cursor.getAttrValue("name");
        String file = cursor.getAttrValue("file");
        double time = 0.0;
        String timeAttributeValue = cursor.getAttrValue("time");
        if (timeAttributeValue != null) {
            try {
                time = Double.parseDouble(timeAttributeValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        ArrayList<TestSuite> nestedSuites = new ArrayList<TestSuite>();
        SMInputCursor childCursor = file != null ? cursor.descendantElementCursor("testcase") : cursor.childCursor();
        while (childCursor.getNext() != null) {
            String childName = childCursor.getLocalName();
            if ("testsuite".equals(childName)) {
                nestedSuites.add(JUnitLogParserForPhpUnit.processTestSuite(childCursor));
                continue;
            }
            if (!"testcase".equals(childName)) continue;
            testCases.add(JUnitLogParserForPhpUnit.processTestCase(childCursor));
        }
        TestSuite testSuite = new TestSuite(name, file, time, testCases);
        nestedSuites.forEach(testSuite::addNested);
        return testSuite;
    }

    private static TestCase processTestCase(SMInputCursor cursor) throws XMLStreamException {
        String className = cursor.getAttrValue("class");
        String name = cursor.getAttrValue("name");
        SMInputCursor childCursor = cursor.childCursor();
        HashMap<String, String> childValues = new HashMap<String, String>();
        while (childCursor.getNext() != null) {
            if (childCursor.getLocalName() == null) continue;
            childValues.put(childCursor.getLocalName(), childCursor.collectDescendantText(false));
        }
        return new TestCase(className, name, (String)childValues.get("error"), (String)childValues.get("failure"), (String)childValues.get("skipped"));
    }
}

