/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.checks.verifier.internal.SecondaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.UnderlinedRange;

public class FlowLocation
extends SecondaryLocation {
    public final int flowIndex;
    public final int indexInTheFlow;

    public FlowLocation(UnderlinedRange range, boolean primaryIsBefore, int flowIndex, int indexInTheFlow, @Nullable String message) {
        super(range, primaryIsBefore, flowIndex, message);
        this.flowIndex = flowIndex;
        this.indexInTheFlow = indexInTheFlow;
    }

    @Override
    public void write(int indent, StringBuilder out, boolean primaryIsWritten) {
        this.range.underline(indent, out);
        out.append(primaryIsWritten ? (char)'<' : '>');
        out.append(' ').append(this.flowIndex).append('.').append(this.indexInTheFlow);
        if (this.message != null) {
            out.append(" {{").append(this.message).append("}}");
        }
    }
}

