/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.quickfix;

public class TextSpan {
    public final int startLine;
    public final int startCharacter;
    public final int endLine;
    public final int endCharacter;

    public TextSpan(int line) {
        this(line, -1, line, -1);
    }

    public TextSpan(int startLine, int startCharacter, int endLine, int endCharacter) {
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
    }

    public String toString() {
        return "(" + this.startLine + ":" + this.startCharacter + ")-(" + this.endLine + ":" + this.endCharacter + ")";
    }

    public boolean onLine() {
        return this.startCharacter == -1;
    }

    public boolean isEmpty() {
        return this.startLine == this.endLine && this.startCharacter == this.endCharacter;
    }

    public int hashCode() {
        int prime = 29;
        int result = 1;
        result = prime * result + this.startLine;
        result = prime * result + this.startCharacter;
        result = prime * result + this.endLine;
        result = prime * result + this.endCharacter;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextSpan)) {
            return false;
        }
        TextSpan other = (TextSpan)obj;
        return this.startLine == other.startLine && this.startCharacter == other.startCharacter && this.endLine == other.endLine && this.endCharacter == other.endCharacter;
    }
}

