/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

public class SequenceTree
extends RegexTree {
    private final List<RegexTree> items;

    public SequenceTree(RegexSource source, IndexRange range, List<RegexTree> items, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.items = items;
        for (int i = 0; i < items.size() - 1; ++i) {
            items.get(i).setContinuation(items.get(i + 1));
        }
    }

    public List<RegexTree> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitSequence(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.SEQUENCE;
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    @Nonnull
    public List<AutomatonState> successors() {
        if (this.items.isEmpty()) {
            return Collections.singletonList(this.continuation());
        }
        return Collections.singletonList((AutomatonState)this.items.get(0));
    }

    @Override
    public void setContinuation(AutomatonState continuation) {
        super.setContinuation(continuation);
        if (!this.items.isEmpty()) {
            this.items.get(this.items.size() - 1).setContinuation(continuation);
        }
    }
}

