/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;

public class UnquantifiedNonCapturingGroupFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Unwrap this unnecessarily grouped subpattern.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private boolean quantifiedNonCapturingGroup = false;

    public UnquantifiedNonCapturingGroupFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        this.quantifiedNonCapturingGroup = tree.getElement().is(RegexTree.Kind.NON_CAPTURING_GROUP);
        super.visitRepetition(tree);
    }

    @Override
    public void visitNonCapturingGroup(NonCapturingGroupTree tree) {
        RegexTree groupElement = tree.getElement();
        if (!this.quantifiedNonCapturingGroup && groupElement != null && !groupElement.is(RegexTree.Kind.DISJUNCTION)) {
            this.regexElementIssueReporter.report(tree, MESSAGE, null, Collections.emptyList());
        }
        this.quantifiedNonCapturingGroup = false;
        super.visitNonCapturingGroup(tree);
    }
}

