/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons;

import com.teamscale.commons.TeamscaleInstallationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.jspecify.annotations.NonNull;

public class TextResourceLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String resourceDirectoryName;
    private final UnmodifiableSet<Path> resourceDirectories;

    public TextResourceLoader(String resourceDirectoryName) {
        this.resourceDirectoryName = resourceDirectoryName;
        this.resourceDirectories = CollectionUtils.asUnmodifiable(this.collectResourceDirectories());
    }

    private Set<Path> collectResourceDirectories() {
        HashSet<Path> result = new HashSet<Path>();
        TeamscaleInstallationUtils.locateRootPath(this.resourceDirectoryName).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::toAbsolutePath).ifPresent(result::add);
        if (result.isEmpty() && EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            result.addAll((Collection<Path>)TeamscaleInstallationUtils.getRepositoryDirectories(this.resourceDirectoryName));
        }
        return result;
    }

    public Optional<String> getTextResource(Class<?> contextClass, String resourcePath) {
        Optional<String> optional;
        block9: {
            Optional<InputStream> resourceStream = this.getTextResourceStream(contextClass, resourcePath);
            if (resourceStream.isEmpty()) {
                return Optional.empty();
            }
            InputStream stream = resourceStream.get();
            try {
                optional = Optional.of(FileSystemUtils.readStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to read resource {}", (Object)resourcePath, (Object)e);
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    public Optional<InputStream> getTextResourceStream(@NonNull Class<?> contextClass, @NonNull String resourcePath) {
        CCSMAssert.isNotNull(contextClass, () -> String.format("Expected \"%s\" to be not null", "contextClass"));
        CCSMAssert.isNotNull((Object)resourcePath, () -> String.format("Expected \"%s\" to be not null", "resourcePath"));
        CCSMAssert.isNotEmpty((String)resourcePath, (String)"The given resource path must not be empty");
        CCSMAssert.isFalse((boolean)resourcePath.startsWith("/"), () -> String.format("Resource path \"%s\" must not start with a '/'", resourcePath));
        Optional classPathResource = Resource.asOptional(contextClass, (String)("/" + this.resourceDirectoryName + "/" + resourcePath));
        Optional<Path> fileResource = this.getFileFromDirectories(resourcePath);
        if (fileResource.isPresent()) {
            if (classPathResource.isPresent()) {
                LOGGER.warn("Resource has both a file in the filesystem and in the classpath {}. The resource from the filesystem will be used.", (Object)fileResource.get().toAbsolutePath());
            }
            try {
                return Optional.of(Files.newInputStream(fileResource.get(), new OpenOption[0]));
            }
            catch (IOException e) {
                LOGGER.warn("Unable to read resource from {}", (Object)fileResource.get().toAbsolutePath(), (Object)e);
            }
        }
        return classPathResource.map(Resource::getAsStream);
    }

    private Optional<Path> getFileFromDirectories(String resourcePath) {
        List<Path> resolvedResources = this.resourceDirectories.stream().map(dir -> dir.resolve(resourcePath)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
        if (resolvedResources.isEmpty()) {
            return Optional.empty();
        }
        if (resolvedResources.size() > 1) {
            LOGGER.warn("Resource has multiple files {}. Using first entry", new Supplier[]{() -> resolvedResources.stream().map(Path::toAbsolutePath).collect(Collectors.toList())});
        }
        return Optional.of(resolvedResources.get(0));
    }

    public Optional<Path> getDirectoryInResourceFolder(String descriptionPath) {
        List<Path> resolvedCheckDescriptions = this.getResourceDirectories().stream().map(dir -> dir.resolve(descriptionPath)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
        if (resolvedCheckDescriptions.isEmpty()) {
            return Optional.empty();
        }
        if (resolvedCheckDescriptions.size() > 1) {
            LOGGER.warn("Multiple matches for directory name {} in {}. Using first entry", new Supplier[]{() -> resolvedCheckDescriptions.stream().map(Path::toAbsolutePath).collect(Collectors.toList()), () -> this.resourceDirectoryName});
        }
        return Optional.of(resolvedCheckDescriptions.getFirst());
    }

    private UnmodifiableSet<Path> getResourceDirectories() {
        return this.resourceDirectories;
    }
}

