/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class QualifiedNameLocation
extends ElementLocation {
    private static final long serialVersionUID = 1L;
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private static final String ABBREVIATED_PROPERTY = "abbreviated";
    private static final String SIGNAL_NAMES_PROPERTY = "signalNames";
    @JsonProperty(value="qualifiedName")
    private final String qualifiedName;
    @JsonProperty(value="abbreviated")
    private final boolean abbreviated;
    @JsonProperty(value="signalNames")
    private final List<String> signalNames;

    public QualifiedNameLocation(String qualifiedName, String uniformPath) {
        this(qualifiedName, uniformPath, false);
    }

    public QualifiedNameLocation(String qualifiedName, String uniformPath, boolean abbreviated) {
        this(qualifiedName, uniformPath, abbreviated, Collections.emptyList());
    }

    @JsonCreator
    public QualifiedNameLocation(@JsonProperty(value="qualifiedName") String qualifiedName, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="abbreviated") boolean abbreviated, @JsonProperty(value="signalNames") List<String> signalNames) {
        super(uniformPath);
        CCSMAssert.isNotNull((Object)qualifiedName);
        this.qualifiedName = qualifiedName;
        this.abbreviated = abbreviated;
        this.signalNames = new ArrayList<String>(signalNames);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String toLocationString() {
        return super.toLocationString() + ":" + this.qualifiedName;
    }

    public boolean isAbbreviated() {
        return this.abbreviated;
    }

    public List<String> getSignalNames() {
        return this.signalNames;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QualifiedNameLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QualifiedNameLocation)) {
            return false;
        }
        QualifiedNameLocation that = (QualifiedNameLocation)o;
        return that.canEqual(this) && Objects.equals(this.qualifiedName, that.qualifiedName) && this.abbreviated == that.abbreviated && Objects.equals(this.signalNames, that.signalNames) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.qualifiedName, this.abbreviated, this.signalNames);
    }
}

