/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.string.LineRangeStringParser;

public class LineRangeSerializer
extends StdSerializer<CompactLines> {
    private static final long serialVersionUID = 1L;

    public LineRangeSerializer() {
        this(null);
    }

    private LineRangeSerializer(Class<CompactLines> t) {
        super(t);
    }

    public void serialize(CompactLines value, JsonGenerator jsonGen, SerializerProvider provider) throws IOException {
        List compactLineRanges = LineRangeStringParser.compactifyToRanges((CompactLines)value);
        String concatenatedCompactLineRanges = compactLineRanges.stream().map(Object::toString).collect(Collectors.joining(","));
        jsonGen.writeString(concatenatedCompactLineRanges);
    }
}

