/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.js_export.NotExported;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ExportToTypeScript
@IndexValueClass
public class BasicTokenElementInfo
implements Serializable {
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String LANGUAGE_PROPERTY = "language";
    private static final String IS_LANGUAGE_SET_BY_USER_PROPERTY = "isLanguageSetByUser";
    private static final String TEXT_PROPERTY = "text";
    private static final String FILTER_DELETIONS_PROPERTY = "filterDeletions";
    private static final String DETAILS_PROPERTY = "details";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uniformPath")
    protected final String uniformPath;
    @JsonProperty(value="language")
    protected final ELanguage language;
    @JsonProperty(value="isLanguageSetByUser")
    @NotExported
    private final boolean isFileLanguageSetByUser;
    @JsonProperty(value="text")
    protected final String text;
    @JsonProperty(value="filterDeletions")
    protected final ArrayList<Deletion> filterDeletions;
    @JsonProperty(value="details")
    protected final ArrayList<TokenElementDetailBase> details;

    @JsonCreator
    public BasicTokenElementInfo(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="language") ELanguage language, @JsonProperty(value="isLanguageSetByUser") boolean isFileLanguageSetByUser, @JsonProperty(value="text") String text, @JsonProperty(value="filterDeletions") Collection<Deletion> filterDeletions, @JsonProperty(value="details") Collection<TokenElementDetailBase> details) {
        this.uniformPath = uniformPath;
        this.language = language;
        this.isFileLanguageSetByUser = isFileLanguageSetByUser;
        this.text = text;
        this.filterDeletions = new ArrayList();
        if (filterDeletions != null) {
            this.filterDeletions.addAll(filterDeletions);
        }
        Collections.sort(this.filterDeletions);
        this.details = new ArrayList();
        if (details != null) {
            this.details.addAll(details);
        }
    }

    public BasicTokenElementInfo(UniformPath uniformPath, ELanguage language, boolean isFileLanguageSetByUser, String text, Collection<Deletion> filterDeletions, Collection<TokenElementDetailBase> details) {
        this(uniformPath.toStringAsMigrationFrontier(), language, isFileLanguageSetByUser, text, filterDeletions, details);
    }

    protected BasicTokenElementInfo(BasicTokenElementInfo other) {
        this(other.uniformPath, other.language, other.isFileLanguageSetByUser, other.text, other.filterDeletions, other.details);
    }

    public BasicTokenElementInfo(BasicTokenElementInfo other, ELanguage language) {
        this(other.uniformPath, language, other.isFileLanguageSetByUser, other.text, other.filterDeletions, other.details);
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public ELanguage getLanguage() {
        return this.language;
    }

    public boolean getIsFileLanguageSetByUser() {
        return this.isFileLanguageSetByUser;
    }

    public String getText() {
        return this.text;
    }

    public String getFilteredText() {
        return new StringOffsetTransformer(this.filterDeletions).filterString(this.text);
    }

    public UnmodifiableList<Deletion> getFilterDeletions() {
        return CollectionUtils.asUnmodifiable(this.filterDeletions);
    }

    public UnmodifiableList<TokenElementDetailBase> getDetails() {
        return CollectionUtils.asUnmodifiable(this.details);
    }

    public <T extends TokenElementDetailBase> Optional<T> getFirstDetailOfType(Class<T> type) {
        return BasicTokenElementInfo.getFirstDetailOfType(type, this.details);
    }

    public static <T extends TokenElementDetailBase> Optional<T> getFirstDetailOfType(Class<T> type, List<TokenElementDetailBase> details) {
        for (TokenElementDetailBase detail : details) {
            if (!type.isInstance(detail)) continue;
            return Optional.of(detail);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.uniformPath;
    }

    public void addDetail(TokenElementDetailBase detail) {
        this.details.add(detail);
    }
}

