/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.resource.text.filter.util;

import java.util.Arrays;
import java.util.List;
import org.conqat.engine.resource.text.filter.base.Deletion;

public class StringOffsetTransformer {
    private int[] rawOffset;
    private int[] filteredOffset;

    public StringOffsetTransformer(List<Deletion> deletions) {
        deletions = Deletion.compactDeletions(deletions);
        int start = 0;
        if (!deletions.isEmpty() && deletions.get(0).getStartOffset() == 0) {
            ++start;
            this.initOffsetArrays(deletions.size());
            this.rawOffset[0] = deletions.get(0).getEndOffset();
            this.filteredOffset[0] = 0;
        } else {
            this.initOffsetArrays(deletions.size() + 1);
            this.rawOffset[0] = 0;
            this.filteredOffset[0] = 0;
        }
        int filteredLength = 0;
        for (int i = start; i < deletions.size(); ++i) {
            Deletion deletion = deletions.get(i);
            this.rawOffset[i + 1 - start] = deletion.getEndOffset();
            this.filteredOffset[i + 1 - start] = filteredLength += deletion.getStartOffset() - this.rawOffset[i - start];
        }
    }

    private void initOffsetArrays(int size) {
        this.rawOffset = new int[size];
        this.filteredOffset = new int[size];
    }

    public String filterString(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.rawOffset.length; ++i) {
            int length = this.filteredOffset[i] - this.filteredOffset[i - 1];
            int begin = this.rawOffset[i - 1];
            int end = this.rawOffset[i - 1] + length;
            sb.append(s, begin, end);
        }
        int index = this.rawOffset[this.rawOffset.length - 1];
        if (index < s.length()) {
            sb.append(s.substring(index));
        }
        return sb.toString();
    }

    public int getUnfilteredOffset(int offset) {
        int index = Arrays.binarySearch(this.filteredOffset, offset);
        if (index < 0) {
            index = -index - 2;
        }
        return this.rawOffset[index] + (offset - this.filteredOffset[index]);
    }

    public int getFilteredOffset(int unfilteredOffset) {
        int delta;
        int index = Arrays.binarySearch(this.rawOffset, unfilteredOffset);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            return 0;
        }
        int validRange = Integer.MAX_VALUE;
        if (index + 1 < this.filteredOffset.length) {
            validRange = this.filteredOffset[index + 1] - this.filteredOffset[index];
        }
        if ((delta = unfilteredOffset - this.rawOffset[index]) <= validRange) {
            return this.filteredOffset[index] + delta;
        }
        return this.filteredOffset[index + 1];
    }

    public boolean isFilteredOffset(int offset) {
        int index = Arrays.binarySearch(this.rawOffset, offset);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            return true;
        }
        if (index >= this.rawOffset.length - 1) {
            return false;
        }
        int validRange = this.rawOffset[index] + this.filteredOffset[index + 1] - this.filteredOffset[index];
        return offset >= validRange;
    }
}

