/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class DecisionProbeConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="executionCount")
    private int executionCount;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="decisionValue")
    private final boolean decisionValue;

    @JsonCreator
    public DecisionProbeConfiguration(@JsonProperty(value="decisionValue") boolean decisionValue, @JsonProperty(value="executionCount") int executionCount, @JsonProperty(value="description") String description) {
        this.decisionValue = decisionValue;
        this.description = description;
        this.executionCount = executionCount;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDecisionValue() {
        return this.decisionValue;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public String toString() {
        return this.executionCount + "(" + this.description + ")";
    }

    public static boolean haveSameDescriptionAndDecisionValue(DecisionProbeConfiguration configuration1, DecisionProbeConfiguration configuration2) {
        return configuration1.decisionValue == configuration2.decisionValue && Objects.equals(configuration1.description, configuration2.description);
    }

    public void increaseExecutionCount(int amount) {
        this.executionCount += amount;
    }
}

