/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.clang;

import eu.cqse.clang.Clang;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;

public class ClangJniLoader {
    private static boolean loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void ensureLoaded() throws UnsatisfiedLinkError, RuntimeException {
        if (loaded) {
            return;
        }
        loaded = true;
        String string = ClangJniLoader.determineLibraryName();
        File file = ClangJniLoader.createTempDirectory();
        file.deleteOnExit();
        File file2 = new File(file, string);
        try (InputStream inputStream = ClangJniLoader.class.getResourceAsStream(string);){
            Files.copy(inputStream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            file2.delete();
            throw new RuntimeException("Failed to copy library to temp folder: " + iOException.getMessage(), iOException);
        }
        try {
            System.load(file2.getAbsolutePath());
            ClangJniLoader.prepareClangEnvironment();
        }
        finally {
            if (ClangJniLoader.isPosixCompliant()) {
                file2.delete();
            } else {
                file2.deleteOnExit();
            }
        }
    }

    private static void prepareClangEnvironment() {
        Clang.clang_putenv("LIBCLANG_DISABLE_CRASH_RECOVERY=1");
    }

    private static String determineLibraryName() throws UnsatisfiedLinkError {
        String string;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.contains("mac")) {
            string = "libclang-mac.dylib";
        } else if (string2.contains("win")) {
            string = "libclang-win.dll";
        } else if (string2.contains("linux")) {
            string = "libclang-linux.so";
        } else {
            throw new RuntimeException("No library available for OS " + string2);
        }
        return string;
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException runtimeException) {
            return false;
        }
    }

    private static File createTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string, "clang-jni-" + System.nanoTime());
        if (!file.mkdir()) {
            throw new RuntimeException("Failed to create temp directory " + file.getName());
        }
        return file;
    }
}

