/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.classloader;

import java.util.ArrayList;
import java.util.List;

public class Mask {
    private static final String ROOT = "/";
    private final List<String> inclusions = new ArrayList<String>();
    private final List<String> exclusions = new ArrayList<String>();

    List<String> getInclusions() {
        return this.inclusions;
    }

    List<String> getExclusions() {
        return this.exclusions;
    }

    public Mask addInclusion(String s) {
        this.inclusions.add(s);
        return this;
    }

    public Mask addExclusion(String s) {
        this.exclusions.add(s);
        return this;
    }

    boolean acceptClass(String classname) {
        if (this.inclusions.isEmpty() && this.exclusions.isEmpty()) {
            return true;
        }
        return this.acceptResource(this.classToResource(classname));
    }

    boolean acceptResource(String name) {
        boolean ok = true;
        if (!this.inclusions.isEmpty()) {
            ok = false;
            for (String include : this.inclusions) {
                if (!this.matchPattern(name, include)) continue;
                ok = true;
                break;
            }
        }
        if (ok) {
            for (String exclude : this.exclusions) {
                if (!this.matchPattern(name, exclude)) continue;
                ok = false;
                break;
            }
        }
        return ok;
    }

    private boolean matchPattern(String name, String pattern) {
        return pattern.equals(ROOT) || pattern.endsWith(ROOT) && name.startsWith(pattern) || pattern.equals(name);
    }

    void merge(Mask with) {
        ArrayList<String> lowestIncludes = new ArrayList<String>();
        if (this.inclusions.isEmpty()) {
            lowestIncludes.addAll(with.inclusions);
        } else if (with.inclusions.isEmpty()) {
            lowestIncludes.addAll(this.inclusions);
        } else {
            for (String include : this.inclusions) {
                for (String fromInclude : with.inclusions) {
                    if (!fromInclude.startsWith(include)) continue;
                    lowestIncludes.add(fromInclude);
                }
            }
            for (String fromInclude : with.inclusions) {
                for (String include : this.inclusions) {
                    if (!include.startsWith(fromInclude)) continue;
                    lowestIncludes.add(include);
                }
            }
        }
        this.inclusions.clear();
        this.inclusions.addAll(lowestIncludes);
        this.exclusions.addAll(with.exclusions);
    }

    private String classToResource(String classname) {
        return classname.replace('.', '/') + ".class";
    }
}

