/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.RegexChannel;
import org.sonar.markdown.MarkdownOutput;

class HtmlMultilineCodeChannel
extends RegexChannel<MarkdownOutput> {
    private static final String NEWLINE = "(?:\\n\\r|\\r|\\n)";
    private static final String LANGUAGE = "([a-zA-Z][a-zA-Z0-9_]*+)?";
    private static final String DETECTION_REGEXP = "``([a-zA-Z][a-zA-Z0-9_]*+)?(?:\\n\\r|\\r|\\n)([\\s\\S]+?)(?:\\n\\r|\\r|\\n)``";
    private final Matcher regexpMatcher = Pattern.compile("``([a-zA-Z][a-zA-Z0-9_]*+)?(?:\\n\\r|\\r|\\n)([\\s\\S]+?)(?:\\n\\r|\\r|\\n)``").matcher("");

    public HtmlMultilineCodeChannel() {
        super(DETECTION_REGEXP);
    }

    @Override
    protected void consume(CharSequence token, MarkdownOutput output) {
        this.regexpMatcher.reset(token);
        this.regexpMatcher.matches();
        output.append("<pre");
        String language = this.regexpMatcher.group(1);
        if (language != null) {
            output.append(" lang=\"");
            output.append(language);
            output.append("\"");
        }
        output.append("><code>");
        output.append(this.regexpMatcher.group(2));
        output.append("</code></pre>");
    }
}

