/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.sonarsource.sonarlint.core.BindingClueProvider;
import org.sonarsource.sonarlint.core.SonarProjectsCache;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.binding.BindingService;
import org.sonarsource.sonarlint.core.clientapi.backend.binding.GetBindingSuggestionParams;
import org.sonarsource.sonarlint.core.clientapi.backend.config.binding.BindingSuggestionDto;
import org.sonarsource.sonarlint.core.clientapi.client.binding.GetBindingSuggestionsResponse;
import org.sonarsource.sonarlint.core.clientapi.client.binding.SuggestBindingParams;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.event.BindingConfigChangedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopesAddedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationAddedEvent;
import org.sonarsource.sonarlint.core.repository.config.BindingConfiguration;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.component.ServerProject;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

@Named
@Singleton
public class BindingSuggestionProviderImpl
implements BindingService {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConfigurationRepository configRepository;
    private final ConnectionConfigurationRepository connectionRepository;
    private final SonarLintClient client;
    private final BindingClueProvider bindingClueProvider;
    private final SonarProjectsCache sonarProjectsCache;
    private final ExecutorService executorService;
    private final AtomicBoolean enabled = new AtomicBoolean(true);

    @Inject
    public BindingSuggestionProviderImpl(ConfigurationRepository configRepository, ConnectionConfigurationRepository connectionRepository, SonarLintClient client, BindingClueProvider bindingClueProvider, SonarProjectsCache sonarProjectsCache) {
        this.configRepository = configRepository;
        this.connectionRepository = connectionRepository;
        this.client = client;
        this.bindingClueProvider = bindingClueProvider;
        this.sonarProjectsCache = sonarProjectsCache;
        this.executorService = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "Binding Suggestion Provider"));
    }

    BindingSuggestionProviderImpl(ConfigurationRepository configRepository, ConnectionConfigurationRepository connectionRepository, SonarLintClient client, BindingClueProvider bindingClueProvider, SonarProjectsCache sonarProjectsCache, ExecutorService executorService) {
        this.configRepository = configRepository;
        this.connectionRepository = connectionRepository;
        this.client = client;
        this.bindingClueProvider = bindingClueProvider;
        this.sonarProjectsCache = sonarProjectsCache;
        this.executorService = executorService;
    }

    @Subscribe
    public void bindingConfigChanged(BindingConfigChangedEvent event) {
        if (!event.getNewConfig().isBindingSuggestionDisabled() && event.getPreviousConfig().isBindingSuggestionDisabled()) {
            this.suggestBindingForGivenScopesAndAllConnections(Set.of(event.getConfigScopeId()));
        }
    }

    @Subscribe
    public void configurationScopesAdded(ConfigurationScopesAddedEvent event) {
        Set<String> configScopeIds = event.getAddedConfigurationScopeIds();
        this.suggestBindingForGivenScopesAndAllConnections(configScopeIds);
    }

    private void suggestBindingForGivenScopesAndAllConnections(Set<String> configScopeIdsToSuggest) {
        if (!configScopeIdsToSuggest.isEmpty()) {
            Set<String> allConnectionIds = this.connectionRepository.getConnectionsById().keySet();
            if (allConnectionIds.isEmpty()) {
                LOG.debug("No connections configured, skipping binding suggestions.");
                return;
            }
            LOG.debug("Binding suggestion computation queued for config scopes '{}'...", (Object)String.join((CharSequence)",", configScopeIdsToSuggest));
            this.queueBindingSuggestionComputation(configScopeIdsToSuggest, allConnectionIds);
        }
    }

    @Subscribe
    public void connectionAdded(ConnectionConfigurationAddedEvent event) {
        String addedConnectionId = event.getAddedConnectionId();
        Set<String> allConfigScopeIds = this.configRepository.getConfigScopeIds();
        if (this.connectionRepository.getConnectionById(addedConnectionId) != null && !allConfigScopeIds.isEmpty()) {
            LOG.debug("Binding suggestions computation queued for connection '{}'...", (Object)addedConnectionId);
            Set<String> candidateConnectionIds = Set.of(addedConnectionId);
            this.queueBindingSuggestionComputation(allConfigScopeIds, candidateConnectionIds);
        }
    }

    @Override
    public CompletableFuture<GetBindingSuggestionsResponse> getBindingSuggestions(GetBindingSuggestionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Map<String, List<BindingSuggestionDto>> suggestions = this.computeBindingSuggestions(Set.of(params.getConfigScopeId()), Set.of(params.getConnectionId()), null);
            return new GetBindingSuggestionsResponse(suggestions);
        }, this.executorService);
    }

    private void queueBindingSuggestionComputation(Set<String> configScopeIds, Set<String> candidateConnectionIds) {
        this.executorService.submit(() -> {
            if (this.enabled.get()) {
                this.computeAndNotifyBindingSuggestions(configScopeIds, candidateConnectionIds);
            } else {
                LOG.debug("Skipping binding suggestion computation as it is disabled");
            }
        });
    }

    private void computeAndNotifyBindingSuggestions(Set<String> configScopeIds, Set<String> candidateConnectionIds) {
        Map<String, List<BindingSuggestionDto>> suggestions = this.computeBindingSuggestions(configScopeIds, candidateConnectionIds, null);
        if (!suggestions.isEmpty()) {
            this.client.suggestBinding(new SuggestBindingParams(suggestions));
        }
    }

    @NonNull
    public Map<String, List<BindingSuggestionDto>> computeBindingSuggestions(Set<String> configScopeIds, Set<String> candidateConnectionIds, @Nullable String projectKey) {
        HashSet<String> eligibleConfigScopesForBindingSuggestion = new HashSet<String>();
        for (String string : configScopeIds) {
            if (!this.isScopeEligibleForBindingSuggestion(string)) continue;
            eligibleConfigScopesForBindingSuggestion.add(string);
        }
        if (eligibleConfigScopesForBindingSuggestion.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<BindingSuggestionDto>> suggestions = new HashMap<String, List<BindingSuggestionDto>>();
        try {
            for (String configScopeId : eligibleConfigScopesForBindingSuggestion) {
                List<BindingSuggestionDto> scopeSuggestions = this.suggestBindingForEligibleScope(configScopeId, candidateConnectionIds, projectKey);
                LOG.debug("Found {} {} for configuration scope '{}'", scopeSuggestions.size(), SonarLintLogger.singlePlural(scopeSuggestions.size(), "suggestion", "suggestions"), configScopeId);
                suggestions.put(configScopeId, scopeSuggestions);
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.debug("Binding suggestion computation was interrupted", (Object)interruptedException);
            Thread.currentThread().interrupt();
        }
        return suggestions;
    }

    private List<BindingSuggestionDto> suggestBindingForEligibleScope(String checkedConfigScopeId, Set<String> candidateConnectionIds, @Nullable String projectKey) throws InterruptedException {
        String configScopeName;
        List<BindingClueProvider.BindingClueWithConnections> cluesAndConnections = this.bindingClueProvider.collectBindingCluesWithConnections(checkedConfigScopeId, candidateConnectionIds, projectKey);
        ArrayList<BindingSuggestionDto> suggestions = new ArrayList<BindingSuggestionDto>();
        List cluesWithProjectKey = cluesAndConnections.stream().filter(c -> c.getBindingClue().getSonarProjectKey() != null).collect(Collectors.toList());
        for (BindingClueProvider.BindingClueWithConnections bindingClueWithConnections : cluesWithProjectKey) {
            String sonarProjectKey = Objects.requireNonNull(bindingClueWithConnections.getBindingClue().getSonarProjectKey());
            if (sonarProjectKey.equals(projectKey)) {
                return suggestions;
            }
            for (String connectionId : bindingClueWithConnections.getConnectionIds()) {
                this.sonarProjectsCache.getSonarProject(connectionId, sonarProjectKey).ifPresent(serverProject -> suggestions.add(new BindingSuggestionDto(connectionId, sonarProjectKey, serverProject.getName())));
            }
        }
        if (suggestions.isEmpty() && StringUtils.isNotBlank(configScopeName = (String)Optional.ofNullable(this.configRepository.getConfigurationScope(checkedConfigScopeId)).map(ConfigurationScope::getName).orElse(null))) {
            List cluesWithoutProjectKey = cluesAndConnections.stream().filter(c -> c.getBindingClue().getSonarProjectKey() == null).collect(Collectors.toList());
            for (BindingClueProvider.BindingClueWithConnections bindingClueWithConnections : cluesWithoutProjectKey) {
                this.searchGoodMatchInConnections(suggestions, configScopeName, bindingClueWithConnections.getConnectionIds(), projectKey);
            }
            if (cluesWithoutProjectKey.isEmpty()) {
                this.searchGoodMatchInConnections(suggestions, configScopeName, candidateConnectionIds, projectKey);
            }
        }
        return suggestions;
    }

    private void searchGoodMatchInConnections(List<BindingSuggestionDto> suggestions, String configScopeName, Set<String> connectionIdsToSearch, @Nullable String projectKey) {
        for (String connectionId : connectionIdsToSearch) {
            this.searchGoodMatchInConnection(suggestions, configScopeName, connectionId, projectKey);
        }
    }

    private void searchGoodMatchInConnection(List<BindingSuggestionDto> suggestions, String configScopeName, String connectionId, @Nullable String projectKey) {
        LOG.debug("Attempt to find a good match for '{}' on connection '{}'...", (Object)configScopeName, (Object)connectionId);
        TextSearchIndex<ServerProject> index = this.sonarProjectsCache.getTextSearchIndexCached(connectionId, projectKey);
        Map<ServerProject, Double> searchResult = index.search(configScopeName);
        if (!searchResult.isEmpty()) {
            Double bestScore = Double.MIN_VALUE;
            for (Map.Entry<ServerProject, Double> serverProjectScoreEntry : searchResult.entrySet()) {
                if (serverProjectScoreEntry.getValue() < bestScore) break;
                bestScore = serverProjectScoreEntry.getValue();
                suggestions.add(new BindingSuggestionDto(connectionId, serverProjectScoreEntry.getKey().getKey(), serverProjectScoreEntry.getKey().getName()));
            }
            LOG.debug("Best score = {}", (Object)String.format(Locale.ENGLISH, "%,.2f", bestScore));
        }
    }

    private boolean isScopeEligibleForBindingSuggestion(String configScopeId) {
        ConfigurationScope configScope = this.configRepository.getConfigurationScope(configScopeId);
        BindingConfiguration bindingConfiguration = this.configRepository.getBindingConfiguration(configScopeId);
        if (configScope == null || bindingConfiguration == null) {
            LOG.debug("Configuration scope '{}' is gone.", (Object)configScopeId);
            return false;
        }
        if (!configScope.isBindable()) {
            LOG.debug("Configuration scope '{}' is not bindable.", (Object)configScopeId);
            return false;
        }
        if (this.isValidBinding(bindingConfiguration)) {
            LOG.debug("Configuration scope '{}' is already bound.", (Object)configScopeId);
            return false;
        }
        if (bindingConfiguration.isBindingSuggestionDisabled()) {
            LOG.debug("Configuration scope '{}' has binding suggestions disabled.", (Object)configScopeId);
            return false;
        }
        return true;
    }

    private boolean isValidBinding(BindingConfiguration bindingConfiguration) {
        return bindingConfiguration.ifBound((connectionId, projectKey) -> this.connectionRepository.getConnectionById((String)connectionId) != null).orElse(false);
    }

    @PreDestroy
    public void shutdown() {
        if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Unable to stop binding suggestions executor service in a timely manner");
        }
    }

    public void disable() {
        this.enabled.set(false);
    }

    public void enable() {
        this.enabled.set(true);
    }
}

