/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.ConnectionAwareHttpClientProvider;
import org.sonarsource.sonarlint.core.http.ConnectionUnawareHttpClientProvider;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.connection.SonarCloudConnectionConfiguration;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;

@Named
@Singleton
public class ServerApiProvider {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConnectionConfigurationRepository connectionRepository;
    private final ConnectionAwareHttpClientProvider awareHttpClientProvider;
    private final ConnectionUnawareHttpClientProvider unawareHttpClientProvider;

    public ServerApiProvider(ConnectionConfigurationRepository connectionRepository, ConnectionAwareHttpClientProvider awareHttpClientProvider, ConnectionUnawareHttpClientProvider unawareHttpClientProvider) {
        this.connectionRepository = connectionRepository;
        this.awareHttpClientProvider = awareHttpClientProvider;
        this.unawareHttpClientProvider = unawareHttpClientProvider;
    }

    public Optional<ServerApi> getServerApi(String connectionId) {
        Optional<EndpointParams> params = this.connectionRepository.getEndpointParams(connectionId);
        if (params.isEmpty()) {
            LOG.debug("Connection '{}' is gone", (Object)connectionId);
            return Optional.empty();
        }
        return Optional.of(new ServerApi(params.get(), this.awareHttpClientProvider.getHttpClient(connectionId)));
    }

    public ServerApi getServerApi(String baseUrl, @Nullable String organization, String token) {
        EndpointParams params = new EndpointParams(baseUrl, SonarCloudConnectionConfiguration.getSonarCloudUrl().equals(baseUrl), organization);
        return new ServerApi(params, this.unawareHttpClientProvider.getHttpClient(token));
    }
}

