/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.DefaultFilePredicates;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.InputFileIndex;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.OptimizedFilePredicateAdapter;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputDir;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class SonarLintFileSystem
implements FileSystem {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final DefaultFilePredicates filePredicates;
    private final Path baseDir;
    private Charset encoding;
    private final InputFileIndex inputFileCache;

    public SonarLintFileSystem(AnalysisConfiguration analysisConfiguration, InputFileIndex inputFileCache) {
        this.inputFileCache = inputFileCache;
        this.baseDir = analysisConfiguration.baseDir();
        this.filePredicates = new DefaultFilePredicates();
    }

    @Override
    public File workDir() {
        LOG.warn("No workDir in SonarLint");
        return this.baseDir();
    }

    @Override
    public InputDir inputDir(File dir) {
        return new SonarLintInputDir(dir.toPath());
    }

    @Override
    public FilePredicates predicates() {
        return this.filePredicates;
    }

    @Override
    public File baseDir() {
        return this.baseDir.toFile();
    }

    private SonarLintFileSystem setEncoding(Charset c) {
        LOG.debug("Setting filesystem encoding: " + c);
        this.encoding = c;
        return this;
    }

    @Override
    public Charset encoding() {
        if (this.encoding == null) {
            this.setEncoding(StreamSupport.stream(this.inputFiles().spliterator(), false).map(InputFile::charset).findFirst().orElse(Charset.defaultCharset()));
        }
        return this.encoding;
    }

    @Override
    public InputFile inputFile(FilePredicate predicate) {
        Iterable<InputFile> files = this.inputFiles(predicate);
        Iterator<InputFile> iterator = files.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        InputFile first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    public Iterable<InputFile> inputFiles() {
        return this.inputFiles(this.filePredicates.all());
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate predicate) {
        return OptimizedFilePredicateAdapter.create(predicate).get(this.inputFileCache);
    }

    @Override
    public boolean hasFiles(FilePredicate predicate) {
        return this.inputFiles(predicate).iterator().hasNext();
    }

    @Override
    public Iterable<File> files(FilePredicate predicate) {
        return () -> StreamSupport.stream(this.inputFiles(predicate).spliterator(), false).map(InputFile::file).iterator();
    }

    @Override
    public SortedSet<String> languages() {
        return this.inputFileCache.languages();
    }

    @Override
    public File resolvePath(String path) {
        throw new UnsupportedOperationException("resolvePath");
    }
}

