/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.AbstractPatternInitializer;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.BlockIssuePattern;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class IssueExclusionPatternInitializer
extends AbstractPatternInitializer {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final String EXCLUSION_KEY_PREFIX = "sonar.issue.ignore";
    public static final String BLOCK_SUFFIX = ".block";
    public static final String PATTERNS_BLOCK_KEY = "sonar.issue.ignore.block";
    public static final String BEGIN_BLOCK_REGEXP = "beginBlockRegexp";
    public static final String END_BLOCK_REGEXP = "endBlockRegexp";
    public static final String ALLFILE_SUFFIX = ".allfile";
    public static final String PATTERNS_ALLFILE_KEY = "sonar.issue.ignore.allfile";
    public static final String FILE_REGEXP = "fileRegexp";
    private List<BlockIssuePattern> blockPatterns;
    private List<String> allFilePatterns;

    public IssueExclusionPatternInitializer(Configuration config) {
        super(config);
        this.loadFileContentPatterns();
    }

    @Override
    protected String getMulticriteriaConfigurationKey() {
        return "sonar.issue.ignore.multicriteria";
    }

    @Override
    public boolean hasConfiguredPatterns() {
        return this.hasFileContentPattern() || this.hasMulticriteriaPatterns();
    }

    private void loadFileContentPatterns() {
        String propPrefix;
        this.blockPatterns = new ArrayList<BlockIssuePattern>();
        for (String id : this.getSettings().getStringArray(PATTERNS_BLOCK_KEY)) {
            propPrefix = "sonar.issue.ignore.block." + id + ".";
            String beginBlockRegexp = this.getSettings().get(propPrefix + BEGIN_BLOCK_REGEXP).orElse(null);
            if (StringUtils.isBlank(beginBlockRegexp)) {
                LOG.debug("Issue exclusions are misconfigured. Start block regexp is mandatory for each entry of 'sonar.issue.ignore.block'");
                continue;
            }
            String endBlockRegexp = this.getSettings().get(propPrefix + END_BLOCK_REGEXP).orElse(null);
            BlockIssuePattern pattern = new BlockIssuePattern(IssueExclusionPatternInitializer.nullToEmpty(beginBlockRegexp), IssueExclusionPatternInitializer.nullToEmpty(endBlockRegexp));
            this.blockPatterns.add(pattern);
        }
        this.blockPatterns = Collections.unmodifiableList(this.blockPatterns);
        this.allFilePatterns = new ArrayList<String>();
        for (String id : this.getSettings().getStringArray(PATTERNS_ALLFILE_KEY)) {
            propPrefix = "sonar.issue.ignore.allfile." + id + ".";
            String allFileRegexp = this.getSettings().get(propPrefix + FILE_REGEXP).orElse(null);
            if (StringUtils.isBlank(allFileRegexp)) {
                LOG.debug("Issue exclusions are misconfigured. Remove blank entries from 'sonar.issue.ignore.allfile'");
                continue;
            }
            this.allFilePatterns.add(IssueExclusionPatternInitializer.nullToEmpty(allFileRegexp));
        }
        this.allFilePatterns = Collections.unmodifiableList(this.allFilePatterns);
    }

    private static String nullToEmpty(@Nullable String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public List<BlockIssuePattern> getBlockPatterns() {
        return this.blockPatterns;
    }

    public List<String> getAllFilePatterns() {
        return this.allFilePatterns;
    }

    public boolean hasFileContentPattern() {
        return !this.blockPatterns.isEmpty() || !this.allFilePatterns.isEmpty();
    }
}

