/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.common;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class ClientFileExclusions
implements Predicate<String> {
    private static final String SYNTAX = "glob";
    private final List<PathMatcher> matchers;
    private final Set<String> directoryExclusions;
    private final Set<String> fileExclusions;

    public ClientFileExclusions(Set<String> fileExclusions, Set<String> directoryExclusions, Set<String> globPatterns) {
        this.fileExclusions = fileExclusions;
        this.directoryExclusions = directoryExclusions;
        this.matchers = ClientFileExclusions.parseGlobPatterns(globPatterns);
    }

    private static List<PathMatcher> parseGlobPatterns(Set<String> globPatterns) {
        FileSystem fs = FileSystems.getDefault();
        ArrayList<PathMatcher> parsedMatchers = new ArrayList<PathMatcher>(globPatterns.size());
        for (String pattern : globPatterns) {
            try {
                parsedMatchers.add(fs.getPathMatcher("glob:" + pattern));
            }
            catch (Exception exception) {}
        }
        return parsedMatchers;
    }

    @Override
    public boolean test(Path path) {
        return this.testFileExclusions(path) || this.testDirectoryExclusions(path) || this.testGlob(path);
    }

    private boolean testGlob(Path path) {
        return this.matchers.stream().anyMatch(matcher -> matcher.matches(path));
    }

    private boolean testFileExclusions(Path path) {
        return this.fileExclusions.contains(path.toString());
    }

    private boolean testDirectoryExclusions(Path path) {
        for (Path p = path; p != null; p = p.getParent()) {
            if (!this.directoryExclusions.contains(p.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(String string) {
        return this.test(Paths.get(string, new String[0]));
    }
}

