/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.standalone;

import java.util.List;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleParamType;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamDefinition;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamType;

public class StandaloneRuleParam {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final String key;
    private final String name;
    private final String description;
    private final String defaultValue;
    private final StandaloneRuleParamType type;
    private final boolean multiple;
    private final List<String> possibleValues;

    public StandaloneRuleParam(SonarLintRuleParamDefinition param) {
        this.key = param.key();
        this.name = param.name();
        this.description = param.description();
        this.defaultValue = param.defaultValue();
        SonarLintRuleParamType apiType = param.type();
        this.type = StandaloneRuleParam.from(apiType);
        this.multiple = param.multiple();
        this.possibleValues = List.copyOf(param.possibleValues());
    }

    private static StandaloneRuleParamType from(SonarLintRuleParamType apiType) {
        try {
            return StandaloneRuleParamType.valueOf(apiType.name());
        }
        catch (IllegalArgumentException unknownType) {
            LOG.warn("Unknown parameter type: " + apiType.name());
            return StandaloneRuleParamType.STRING;
        }
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    @CheckForNull
    public String defaultValue() {
        return this.defaultValue;
    }

    public StandaloneRuleParamType type() {
        return this.type;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public List<String> possibleValues() {
        return this.possibleValues;
    }
}

