/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;

class LogOutputDelegator {
    private static final Pattern SKIPPED_MESSAGE_PATTERN = Pattern.compile("^Skipping section '.*?' for rule '.*?', content is empty$");
    private static final AtomicReference<ClientLogOutput> fallback = new AtomicReference();
    private final InheritableThreadLocal<ClientLogOutput> target = new InheritableThreadLocal();

    LogOutputDelegator() {
    }

    void log(String formattedMessage, ClientLogOutput.Level level) {
        ClientLogOutput output = Optional.ofNullable((ClientLogOutput)this.target.get()).orElse(fallback.get());
        if (output != null) {
            if (level == ClientLogOutput.Level.DEBUG && SKIPPED_MESSAGE_PATTERN.matcher(formattedMessage).matches()) {
                return;
            }
            output.log(formattedMessage, level);
        }
    }

    void log(@Nullable String formattedMessage, ClientLogOutput.Level level, @Nullable Throwable t) {
        if (formattedMessage != null) {
            this.log(formattedMessage, level);
        }
        if (t != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            t.printStackTrace(printWriter);
            this.log(stringWriter.toString(), level);
        }
    }

    void setTarget(@Nullable ClientLogOutput target) {
        fallback.compareAndSet(null, target);
        this.target.set(target);
    }
}

