/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.http.GetProxyPasswordAuthenticationParams;
import org.sonarsource.sonarlint.core.clientapi.client.http.GetProxyPasswordAuthenticationResponse;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

@Named
@Singleton
public class ClientProxyCredentialsProvider
implements CredentialsProvider {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final SonarLintClient client;

    public ClientProxyCredentialsProvider(SonarLintClient client) {
        this.client = client;
    }

    public Credentials getCredentials(AuthScope authScope, @Nullable HttpContext context) {
        String host = authScope.getHost();
        if (host == null) {
            return null;
        }
        String targetHostURL = ClientProxyCredentialsProvider.getTargetHostURL(context);
        String protocol = ClientProxyCredentialsProvider.getProtocol(authScope);
        try {
            GetProxyPasswordAuthenticationResponse response = this.client.getProxyPasswordAuthentication(new GetProxyPasswordAuthenticationParams(authScope.getHost(), authScope.getPort(), protocol, authScope.getRealm(), authScope.getSchemeName(), targetHostURL)).get();
            String proxyUser = response.getProxyUser();
            if (proxyUser != null) {
                String proxyPassword = response.getProxyPassword();
                return new UsernamePasswordCredentials(proxyUser, proxyPassword != null ? proxyPassword.toCharArray() : null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Interrupted!", e);
        }
        catch (ExecutionException e) {
            this.logger.warn("Unable to get proxy credentials from the client", e);
        }
        return null;
    }

    private static String getProtocol(AuthScope authScope) {
        String protocol = authScope.getProtocol() != null ? authScope.getProtocol() : (authScope.getPort() == 443 ? URIScheme.HTTPS.id : URIScheme.HTTP.id);
        return protocol;
    }

    @CheckForNull
    private static String getTargetHostURL(@Nullable HttpContext context) {
        String targetHostURL;
        HttpClientContext clientContext = context != null ? HttpClientContext.adapt((HttpContext)context) : null;
        HttpRequest request = context != null ? clientContext.getRequest() : null;
        try {
            URI uri = request != null ? request.getUri() : null;
            targetHostURL = uri != null ? uri.toString() : null;
        }
        catch (URISyntaxException ignore) {
            targetHostURL = null;
        }
        return targetHostURL;
    }
}

