/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.loading;

import java.io.IOException;
import java.io.InputStream;

public class Slf4jBridgeClassLoader
extends ClassLoader {
    private final ClassLoader sonarLintClassLoader;

    public Slf4jBridgeClassLoader(ClassLoader sonarLintClassLoader) {
        super(ClassLoader.getPlatformClassLoader());
        this.sonarLintClassLoader = sonarLintClassLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.sonarsource.sonarlint.core.commons.log")) {
            return this.sonarLintClassLoader.loadClass(name);
        }
        if (name.startsWith("org.slf4j")) {
            Class<?> clazz;
            block11: {
                String path = name.replace('.', '/').concat(".clazz");
                String classContentPath = "slf4j-sonar-log/" + path;
                InputStream is = this.sonarLintClassLoader.getResourceAsStream(classContentPath);
                try {
                    if (is == null) {
                        throw new IllegalStateException("Unable to find resource " + classContentPath);
                    }
                    byte[] classBytes = is.readAllBytes();
                    clazz = this.defineClass(name, classBytes, 0, classBytes.length);
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("Unable to load class " + name, e);
                    }
                }
                is.close();
            }
            return clazz;
        }
        return super.findClass(name);
    }
}

