/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.repository.connection;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;

@Named
@Singleton
public class ConnectionConfigurationRepository {
    private final Map<String, AbstractConnectionConfiguration> connectionsById = new ConcurrentHashMap<String, AbstractConnectionConfiguration>();

    @CheckForNull
    public AbstractConnectionConfiguration addOrReplace(AbstractConnectionConfiguration connectionConfiguration) {
        return this.connectionsById.put(connectionConfiguration.getConnectionId(), connectionConfiguration);
    }

    @CheckForNull
    public AbstractConnectionConfiguration remove(String idToRemove) {
        return this.connectionsById.remove(idToRemove);
    }

    public Map<String, AbstractConnectionConfiguration> getConnectionsById() {
        return Map.copyOf(this.connectionsById);
    }

    @CheckForNull
    public AbstractConnectionConfiguration getConnectionById(String id) {
        return this.connectionsById.get(id);
    }

    public Optional<EndpointParams> getEndpointParams(String connectionId) {
        return Optional.ofNullable(this.getConnectionById(connectionId)).map(AbstractConnectionConfiguration::getEndpointParams);
    }

    public boolean hasConnectionWithOrigin(String serverOrigin) {
        return this.connectionsById.values().stream().anyMatch(connection -> ConnectionConfigurationRepository.haveSameOrigin(connection.getUrl(), serverOrigin));
    }

    public static boolean haveSameOrigin(String knownServerUrl, String incomingOrigin) {
        return ConnectionConfigurationRepository.ensureTrailingSlash(knownServerUrl).startsWith(ConnectionConfigurationRepository.ensureTrailingSlash(incomingOrigin));
    }

    private static String ensureTrailingSlash(String s) {
        return !s.endsWith("/") ? s + "/" : s;
    }

    public List<AbstractConnectionConfiguration> findByUrl(String serverUrl) {
        return this.connectionsById.values().stream().filter(connection -> connection.isSameServerUrl(serverUrl)).collect(Collectors.toList());
    }
}

