/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.server.event;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.serverapi.stream.EventStream;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.events.EventDispatcher;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventsAutoSubscriber;

public class SonarQubeEventStream {
    private EventStream eventStream;
    private final Set<String> subscribedProjectKeys = new LinkedHashSet<String>();
    private final EventDispatcher coreEventRouter;
    private final Set<Language> enabledLanguages;
    private final String connectionId;
    private final ServerApiProvider serverApiProvider;
    private final Consumer<ServerEvent> eventConsumer;

    public SonarQubeEventStream(ConnectionStorage storage, Set<Language> enabledLanguages, String connectionId, ServerApiProvider serverApiProvider, Consumer<ServerEvent> eventConsumer) {
        this.coreEventRouter = ServerEventsAutoSubscriber.getCoreEventHandlers(storage);
        this.enabledLanguages = enabledLanguages;
        this.connectionId = connectionId;
        this.serverApiProvider = serverApiProvider;
        this.eventConsumer = eventConsumer;
    }

    public synchronized void subscribeNew(Set<String> possiblyNewProjectKeys) {
        if (!possiblyNewProjectKeys.isEmpty() && !this.subscribedProjectKeys.containsAll(possiblyNewProjectKeys)) {
            this.cancelSubscription();
            this.subscribedProjectKeys.addAll(possiblyNewProjectKeys);
            this.attemptSubscription(this.subscribedProjectKeys);
        }
    }

    public synchronized void resubscribe() {
        this.cancelSubscription();
        if (!this.subscribedProjectKeys.isEmpty()) {
            this.attemptSubscription(this.subscribedProjectKeys);
        }
    }

    public synchronized void unsubscribe(String projectKey) {
        this.cancelSubscription();
        this.subscribedProjectKeys.remove(projectKey);
        if (!this.subscribedProjectKeys.isEmpty()) {
            this.attemptSubscription(this.subscribedProjectKeys);
        }
    }

    private void attemptSubscription(Set<String> projectKeys) {
        if (!this.enabledLanguages.isEmpty()) {
            this.serverApiProvider.getServerApi(this.connectionId).ifPresent(serverApi -> {
                this.eventStream = serverApi.push().subscribe(projectKeys, this.enabledLanguages, e -> this.notifyHandlers((ServerEvent)e, this.eventConsumer));
            });
        }
    }

    private void notifyHandlers(ServerEvent serverEvent, Consumer<ServerEvent> clientEventConsumer) {
        this.coreEventRouter.handle(serverEvent);
        clientEventConsumer.accept(serverEvent);
    }

    private void cancelSubscription() {
        if (this.eventStream != null) {
            this.eventStream.close();
            this.eventStream = null;
        }
    }

    public synchronized void stop() {
        this.subscribedProjectKeys.clear();
        this.cancelSubscription();
    }
}

