/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;

public class RuleSetChangedEvent
implements ServerEvent {
    private final List<String> projectKeys;
    private final List<ActiveRule> activatedRules;
    private final List<String> deactivatedRules;

    public RuleSetChangedEvent(List<String> projectKeys, List<ActiveRule> activatedRules, List<String> deactivatedRules) {
        this.projectKeys = projectKeys;
        this.activatedRules = activatedRules;
        this.deactivatedRules = deactivatedRules;
    }

    public List<String> getProjectKeys() {
        return this.projectKeys;
    }

    public List<ActiveRule> getActivatedRules() {
        return this.activatedRules;
    }

    public List<String> getDeactivatedRules() {
        return this.deactivatedRules;
    }

    public static class ActiveRule {
        private final String key;
        private final String languageKey;
        private final IssueSeverity severity;
        private final Map<String, String> parameters;
        private final String templateKey;

        public ActiveRule(String key, String languageKey, IssueSeverity severity, Map<String, String> parameters, @Nullable String templateKey) {
            this.key = key;
            this.languageKey = languageKey;
            this.severity = severity;
            this.parameters = parameters;
            this.templateKey = templateKey;
        }

        public String getKey() {
            return this.key;
        }

        public String getLanguageKey() {
            return this.languageKey;
        }

        public IssueSeverity getSeverity() {
            return this.severity;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        @CheckForNull
        public String getTemplateKey() {
            return this.templateKey;
        }
    }
}

