/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;

public class TaintVulnerabilityRaisedEvent
implements ServerEvent {
    private final String key;
    private final String projectKey;
    private final String branchName;
    private final Instant creationDate;
    private final String ruleKey;
    private final IssueSeverity severity;
    private final RuleType type;
    private final Location mainLocation;
    private final List<Flow> flows;
    @Nullable
    private final String ruleDescriptionContextKey;
    @Nullable
    private final CleanCodeAttribute cleanCodeAttribute;
    private final Map<SoftwareQuality, ImpactSeverity> impacts;

    public TaintVulnerabilityRaisedEvent(String key, String projectKey, String branchName, Instant creationDate, String ruleKey, IssueSeverity severity, RuleType type, Location mainLocation, List<Flow> flows, @Nullable String ruleDescriptionContextKey, @Nullable CleanCodeAttribute cleanCodeAttribute, Map<SoftwareQuality, ImpactSeverity> impacts) {
        this.key = key;
        this.projectKey = projectKey;
        this.branchName = branchName;
        this.creationDate = creationDate;
        this.ruleKey = ruleKey;
        this.severity = severity;
        this.type = type;
        this.mainLocation = mainLocation;
        this.flows = flows;
        this.ruleDescriptionContextKey = ruleDescriptionContextKey;
        this.cleanCodeAttribute = cleanCodeAttribute;
        this.impacts = impacts;
    }

    public String getKey() {
        return this.key;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public Instant getCreationDate() {
        return this.creationDate;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public RuleType getType() {
        return this.type;
    }

    public Location getMainLocation() {
        return this.mainLocation;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return Optional.ofNullable(this.cleanCodeAttribute);
    }

    public Map<SoftwareQuality, ImpactSeverity> getImpacts() {
        return this.impacts;
    }

    @CheckForNull
    public String getRuleDescriptionContextKey() {
        return this.ruleDescriptionContextKey;
    }

    public static class Flow {
        private final List<Location> locations;

        public Flow(List<Location> locations) {
            this.locations = locations;
        }

        public List<Location> getLocations() {
            return this.locations;
        }
    }

    public static class Location {
        private final String filePath;
        private final String message;
        private final TextRange textRange;

        public Location(String filePath, String message, TextRange textRange) {
            this.filePath = filePath;
            this.message = message;
            this.textRange = textRange;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getMessage() {
            return this.message;
        }

        public TextRange getTextRange() {
            return this.textRange;
        }

        public static class TextRange {
            private final int startLine;
            private final int startLineOffset;
            private final int endLine;
            private final int endLineOffset;
            private final String hash;

            public TextRange(int startLine, int startLineOffset, int endLine, int endLineOffset, String hash) {
                this.startLine = startLine;
                this.startLineOffset = startLineOffset;
                this.endLine = endLine;
                this.endLineOffset = endLineOffset;
                this.hash = hash;
            }

            public int getStartLine() {
                return this.startLine;
            }

            public int getStartLineOffset() {
                return this.startLineOffset;
            }

            public int getEndLine() {
                return this.endLine;
            }

            public int getEndLineOffset() {
                return this.endLineOffset;
            }

            public String getHash() {
                return this.hash;
            }
        }
    }
}

