/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.settings;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Settings;

public class SettingsApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String API_SETTINGS_PATH = "/api/settings/values.protobuf";
    private final ServerApiHelper helper;

    public SettingsApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public Map<String, String> getProjectSettings(String projectKey) {
        HashMap<String, String> settings = new HashMap<String, String>();
        StringBuilder url = new StringBuilder();
        url.append(API_SETTINGS_PATH);
        url.append("?component=").append(UrlUtils.urlEncode(projectKey));
        ServerApiHelper.consumeTimed(() -> this.helper.get(url.toString()), response -> {
            try (InputStream is = response.bodyAsStream();){
                Settings.ValuesWsResponse values = Settings.ValuesWsResponse.parseFrom(is);
                for (Settings.Setting s : values.getSettingsList()) {
                    SettingsApi.processSetting(settings::put, s);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to parse properties from: " + response.bodyAsString(), e);
            }
        }, duration -> LOG.info("Downloaded settings in {}ms", (Object)duration));
        return settings;
    }

    private static void processSetting(BiConsumer<String, String> consumer, Settings.Setting s) {
        switch (s.getValueOneOfCase()) {
            case VALUE: {
                consumer.accept(s.getKey(), s.getValue());
                break;
            }
            case VALUES: {
                consumer.accept(s.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)s.getValues().getValuesList()));
                break;
            }
            case FIELDVALUES: {
                SettingsApi.processPropertySet(s, consumer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property value for " + s.getKey());
            }
        }
    }

    private static void processPropertySet(Settings.Setting s, BiConsumer<String, String> consumer) {
        ArrayList<String> ids = new ArrayList<String>();
        int id = 1;
        for (Settings.FieldValues.Value v : s.getFieldValues().getFieldValuesList()) {
            for (Map.Entry<String, String> entry : v.getValue().entrySet()) {
                consumer.accept(s.getKey() + "." + id + "." + entry.getKey(), entry.getValue());
            }
            ids.add(String.valueOf(id));
            ++id;
        }
        consumer.accept(s.getKey(), String.join((CharSequence)",", ids));
    }
}

