/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.util;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ProtobufUtil {
    private ProtobufUtil() {
    }

    public static <T extends Message> List<T> readMessages(InputStream input, Parser<T> parser) {
        ArrayList<Message> list = new ArrayList<Message>();
        while (true) {
            Message message;
            try {
                message = (Message)parser.parseDelimitedFrom(input);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("failed to parse protobuf message", e);
            }
            if (message == null) break;
            list.add(message);
        }
        return list;
    }

    public static <T extends Message> void writeMessages(OutputStream output, Iterable<T> messages) {
        for (Message message : messages) {
            ProtobufUtil.writeMessage(output, message);
        }
    }

    static <T extends Message> void writeMessage(OutputStream output, T message) {
        try {
            message.writeDelimitedTo(output);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write message: " + message, e);
        }
    }
}

