/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.file.PathUtils;

public class FileUtils {
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final boolean WINDOWS = System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows");
    private static final int MAX_RETRIES = WINDOWS ? 20 : 0;

    private FileUtils() {
    }

    public static void moveDir(Path src, Path dest) {
        try {
            FileUtils.moveDirPreferAtomic(src, dest);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to move " + src + " to " + dest, e);
        }
    }

    private static void moveDirPreferAtomic(Path src, Path dest) throws IOException {
        try {
            FileUtils.retry(() -> Files.move(src, dest, StandardCopyOption.ATOMIC_MOVE));
        }
        catch (AtomicMoveNotSupportedException e) {
            PathUtils.copyDirectory(src, dest, new CopyOption[0]);
            FileUtils.deleteRecursively(src);
        }
    }

    public static void deleteRecursively(Path path) {
        if (!path.toFile().exists()) {
            return;
        }
        try {
            PathUtils.deleteDirectory(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to delete directory " + path, e);
        }
    }

    public static void mkdirs(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create directory: " + path, e);
        }
    }

    public static void replaceDir(Consumer<Path> dirContentUpdater, Path target, Path work) {
        dirContentUpdater.accept(work);
        FileUtils.deleteRecursively(target);
        FileUtils.mkdirs(target.getParent());
        FileUtils.moveDir(work, target);
    }

    static void retry(IORunnable runnable, int maxRetries) throws IOException {
        for (int retry = 0; retry < maxRetries; ++retry) {
            try {
                runnable.run();
                return;
            }
            catch (AccessDeniedException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        runnable.run();
    }

    static void retry(IORunnable runnable) throws IOException {
        FileUtils.retry(runnable, MAX_RETRIES);
    }

    @FunctionalInterface
    static interface IORunnable {
        public void run() throws IOException;
    }
}

