/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.prefix;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.serverconnection.prefix.ReversePathTree;

public class FileTreeMatcher {
    public Result match(List<Path> serverRelativePaths, List<Path> ideRelativePaths) {
        ReversePathTree reversePathTree = new ReversePathTree();
        LinkedHashMap<Result, Double> resultScores = new LinkedHashMap<Result, Double>();
        Set ideFilenames = ideRelativePaths.stream().map(Path::getFileName).collect(Collectors.toSet());
        serverRelativePaths.stream().filter(sqPath -> ideFilenames.contains(sqPath.getFileName())).forEach(reversePathTree::index);
        for (Path ide : ideRelativePaths) {
            ReversePathTree.Match match = reversePathTree.findLongestSuffixMatches(ide);
            if (match.matchLen() <= 0) continue;
            Path idePrefix = FileTreeMatcher.getIdePrefix(ide, match);
            for (Path sqPrefix : match.matchPrefixes()) {
                Result r = new Result(idePrefix, sqPrefix);
                resultScores.compute(r, (p, i) -> FileTreeMatcher.computeScore(i, match));
            }
        }
        return FileTreeMatcher.higherScoreResult(resultScores);
    }

    private static double computeScore(@Nullable Double currentScore, ReversePathTree.Match match) {
        double matchScore = (double)match.matchLen() / (double)match.matchPrefixes().size();
        return currentScore != null ? currentScore + matchScore : matchScore;
    }

    private static Path getIdePrefix(Path idePath, ReversePathTree.Match match) {
        int prefixLen = FileTreeMatcher.depth(idePath) - match.matchLen();
        if (prefixLen > 0) {
            return idePath.subpath(0, FileTreeMatcher.depth(idePath) - match.matchLen());
        }
        return Paths.get("", new String[0]);
    }

    private static Result higherScoreResult(Map<Result, Double> prefixes) {
        Comparator<Map.Entry> c = Comparator.comparing(Map.Entry::getValue);
        c = c.thenComparing(x -> FileTreeMatcher.depth(((Result)x.getKey()).sqPrefix), Collections.reverseOrder()).thenComparing(x -> ((Result)x.getKey()).sqPrefix.toString(), Collections.reverseOrder());
        return prefixes.entrySet().stream().max(c).map(Map.Entry::getKey).orElse(new Result(Paths.get("", new String[0]), Paths.get("", new String[0])));
    }

    private static int depth(Path path) {
        return path.toString().length() == 0 ? 0 : path.getNameCount();
    }

    public static class Result {
        private final Path idePrefix;
        private final Path sqPrefix;

        Result(Path idePrefix, Path sqPrefix) {
            this.idePrefix = idePrefix;
            this.sqPrefix = sqPrefix;
        }

        public Path idePrefix() {
            return this.idePrefix;
        }

        public Path sqPrefix() {
            return this.sqPrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.idePrefix, result.idePrefix) && Objects.equals(this.sqPrefix, result.sqPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.idePrefix, this.sqPrefix);
        }
    }
}

